/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.sockjs;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * You interact with SockJS clients through instances of SockJS socket.
 * <p>
 * The API is very similar to {@link io.vertx.reactivex.core.http.WebSocket}.
 * It implements both  and 
 * so it can be used with
 * {@link io.vertx.reactivex.core.streams.Pump} to pump data with flow control.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.SockJSSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.sockjs.SockJSSocket.class)
public class SockJSSocket implements io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer>, io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SockJSSocket that = (SockJSSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SockJSSocket> __TYPE_ARG = new TypeArg<>(    obj -> new SockJSSocket((io.vertx.ext.web.handler.sockjs.SockJSSocket) obj),
    SockJSSocket::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.SockJSSocket delegate;
  
  public SockJSSocket(io.vertx.ext.web.handler.sockjs.SockJSSocket delegate) {
    this.delegate = delegate;
  }

  public SockJSSocket(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate;
  }

  public io.vertx.ext.web.handler.sockjs.SockJSSocket getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.reactivex.core.buffer.Buffer> observable;
  private Flowable<io.vertx.reactivex.core.buffer.Buffer> flowable;

  public synchronized Observable<io.vertx.reactivex.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized Flowable<io.vertx.reactivex.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.reactivex.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.reactivex.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.reactivex.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.reactivex.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.reactivex.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      end(handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Completable rxEnd(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      end(data, handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_1);
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket handler(Handler<io.vertx.reactivex.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket write(io.vertx.reactivex.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  /**
   * Write a {@link java.lang.String} to the socket, encoded in UTF-8.
   * @param data the string to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket write(String data) { 
    delegate.write(data);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket write(String data, Handler<AsyncResult<Void>> handler) { 
    io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket ret = io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket.newInstance((io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate.write(data, handler));
    return ret;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket write(io.vertx.reactivex.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

  public Completable rxWrite(io.vertx.reactivex.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      write(data, handler);
    });
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>SockJSSocket</code> is created it automatically registers an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying socket. This
   * allows you to write data to other sockets which are owned by different event loops.
   * @return 
   */
  public String writeHandlerID() { 
    String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Call {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end}.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Close it
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close it giving a status code and reason. Only Applicable to RawWebSocket will downgrade to plain close for
   * other transports.
   * @param statusCode 
   * @param reason 
   */
  public void close(int statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  /**
   * Return the remote address for this socket
   * @return 
   */
  public io.vertx.reactivex.core.net.SocketAddress remoteAddress() { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    return ret;
  }

  /**
   * Return the local address for this socket
   * @return 
   */
  public io.vertx.reactivex.core.net.SocketAddress localAddress() { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    return ret;
  }

  /**
   * Return the headers corresponding to the last request for this socket or the websocket handshake
   * Any cookie headers will be removed for security reasons
   * @return 
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Return the URI corresponding to the last request for this socket or the websocket handshake
   * @return 
   */
  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the Vert.x-Web session corresponding to this socket
   */
  public io.vertx.reactivex.ext.web.Session webSession() { 
    io.vertx.reactivex.ext.web.Session ret = io.vertx.reactivex.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.webSession());
    return ret;
  }

  /**
   * @return the Vert.x-Web user corresponding to this socket
   */
  public io.vertx.reactivex.ext.auth.User webUser() { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.webUser());
    return ret;
  }

  public static SockJSSocket newInstance(io.vertx.ext.web.handler.sockjs.SockJSSocket arg) {
    return arg != null ? new SockJSSocket(arg) : null;
  }

}
