/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.sockjs;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an event that occurs on the event bus bridge.
 * <p>
 * Please consult the documentation for a full explanation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.BridgeEvent original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.sockjs.BridgeEvent.class)
public class BridgeEvent extends io.vertx.reactivex.ext.bridge.BaseBridgeEvent {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BridgeEvent that = (BridgeEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<BridgeEvent> __TYPE_ARG = new TypeArg<>(    obj -> new BridgeEvent((io.vertx.ext.web.handler.sockjs.BridgeEvent) obj),
    BridgeEvent::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.BridgeEvent delegate;
  
  public BridgeEvent(io.vertx.ext.web.handler.sockjs.BridgeEvent delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public BridgeEvent(Object delegate) {
    super((io.vertx.ext.web.handler.sockjs.BridgeEvent)delegate);
    this.delegate = (io.vertx.ext.web.handler.sockjs.BridgeEvent)delegate;
  }

  public io.vertx.ext.web.handler.sockjs.BridgeEvent getDelegate() {
    return delegate;
  }


  /**
   * Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
   * <p/>
   * Any handler set on the associated promise will be called.
   * @param result the result
   */
  public void complete(Boolean result) { 
    delegate.complete(result);
  }

  /**
   * Like {@link io.vertx.reactivex.core.Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
   * an {@link java.lang.IllegalStateException}, it returns <code>true</code> otherwise.
   * @param result the result
   * @return <code>false</code> when the future is already completed
   */
  public boolean tryComplete(Boolean result) { 
    boolean ret = delegate.tryComplete(result);
    return ret;
  }

  /**
   * @return the  associated with this promise, it can be used to be aware of the promise completion
   */
  public io.vertx.reactivex.core.Future<Boolean> future() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.Future<Boolean> ret = io.vertx.reactivex.core.Future.newInstance((io.vertx.core.Future)delegate.future(), TypeArg.unknown());
    cached_0 = ret;
    return ret;
  }

  /**
   * Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
   * no message involved.
   * @param message the raw message
   * @return this reference, so it can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.sockjs.BridgeEvent setRawMessage(JsonObject message) { 
    delegate.setRawMessage(message);
    return this;
  }

  /**
   * Get the SockJSSocket instance corresponding to the event
   * @return the SockJSSocket instance
   */
  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket socket() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket ret = io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket.newInstance((io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate.socket());
    cached_1 = ret;
    return ret;
  }

  private io.vertx.reactivex.core.Future<Boolean> cached_0;
  private io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket cached_1;
  public static BridgeEvent newInstance(io.vertx.ext.web.handler.sockjs.BridgeEvent arg) {
    return arg != null ? new BridgeEvent(arg) : null;
  }

}
