/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.sql;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A ReadStream of Rows from the underlying RDBMS. This class follows the ReadStream semantics and will automatically
 * close the underlying resources if all returned rows are returned. For cases where the results are ignored before the
 * full processing of the returned rows is complete the close method **MUST** be called in order to release underlying
 * resources.
 *
 * The interface is minimal in order to support all SQL clients not just JDBC.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLRowStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.sql.SQLRowStream.class)
public class SQLRowStream implements io.vertx.reactivex.core.streams.ReadStream<JsonArray> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SQLRowStream that = (SQLRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SQLRowStream> __TYPE_ARG = new TypeArg<>(    obj -> new SQLRowStream((io.vertx.ext.sql.SQLRowStream) obj),
    SQLRowStream::getDelegate
  );

  private final io.vertx.ext.sql.SQLRowStream delegate;
  
  public SQLRowStream(io.vertx.ext.sql.SQLRowStream delegate) {
    this.delegate = delegate;
  }

  public SQLRowStream(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLRowStream)delegate;
  }

  public io.vertx.ext.sql.SQLRowStream getDelegate() {
    return delegate;
  }

  private Observable<JsonArray> observable;
  private Flowable<JsonArray> flowable;

  public synchronized Observable<JsonArray> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized Flowable<JsonArray> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }


  /**
   * Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
   * recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
   * be added to the current stream demand.
   * @param amount 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.streams.ReadStream<JsonArray> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<JsonArray> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<JsonArray> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<JsonArray> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.reactivex.core.streams.WriteStream<JsonArray> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<JsonArray> dst) { 
    return AsyncResultCompletable.toCompletable(handler -> {
      pipeTo(dst, handler);
    });
  }

  public io.vertx.reactivex.ext.sql.SQLRowStream exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.sql.SQLRowStream handler(Handler<JsonArray> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.sql.SQLRowStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.ext.sql.SQLRowStream resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.ext.sql.SQLRowStream endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Will convert the column name to the json array index.
   * @param name the column name
   * @return the json array index
   */
  public int column(String name) { 
    int ret = delegate.column(name);
    return ret;
  }

  /**
   * Returns all column names available in the underlying resultset. One needs to carefully use this method since in
   * contrast to the singular version it does not perform case insensitive lookups or takes alias in consideration on
   * the column names.
   * @return the list of columns names returned by the query
   */
  public List<String> columns() { 
    List<String> ret = delegate.columns();
    return ret;
  }

  /**
   * Event handler when a resultset is closed. This is useful to request for more results.
   * @param handler called when the current result set is closed
   * @return 
   */
  public io.vertx.reactivex.ext.sql.SQLRowStream resultSetClosedHandler(Handler<Void> handler) { 
    delegate.resultSetClosedHandler(handler);
    return this;
  }

  /**
   * Request for more results if available
   */
  public void moreResults() { 
    delegate.moreResults();
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * @param handler called when the stream/underlying cursor(s) is(are) closed
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Closes the stream/underlying cursor(s). The actual close happens asynchronously.
   * @return 
   */
  public Completable rxClose() { 
    return AsyncResultCompletable.toCompletable(handler -> {
      close(handler);
    });
  }

  public static SQLRowStream newInstance(io.vertx.ext.sql.SQLRowStream arg) {
    return arg != null ? new SQLRowStream(arg) : null;
  }

}
