/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.term;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A pseudo terminal used for controlling a {@link io.vertx.reactivex.ext.shell.term.Tty}. This interface acts as a pseudo
 * terminal master, {@link io.vertx.reactivex.ext.shell.term.Pty#slave} returns the assocated slave pseudo terminal.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.Pty original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.term.Pty.class)
public class Pty {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pty that = (Pty) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Pty> __TYPE_ARG = new TypeArg<>(    obj -> new Pty((io.vertx.ext.shell.term.Pty) obj),
    Pty::getDelegate
  );

  private final io.vertx.ext.shell.term.Pty delegate;
  
  public Pty(io.vertx.ext.shell.term.Pty delegate) {
    this.delegate = delegate;
  }

  public Pty(Object delegate) {
    this.delegate = (io.vertx.ext.shell.term.Pty)delegate;
  }

  public io.vertx.ext.shell.term.Pty getDelegate() {
    return delegate;
  }

  /**
   * Create a new pseudo terminal with no terminal type.
   * @return 
   */
  public static io.vertx.reactivex.ext.shell.term.Pty create() { 
    io.vertx.reactivex.ext.shell.term.Pty ret = io.vertx.reactivex.ext.shell.term.Pty.newInstance((io.vertx.ext.shell.term.Pty)io.vertx.ext.shell.term.Pty.create());
    return ret;
  }

  /**
   * Create a new pseudo terminal.
   * @param terminalType the terminal type, for instance 
   * @return the created pseudo terminal
   */
  public static io.vertx.reactivex.ext.shell.term.Pty create(String terminalType) { 
    io.vertx.reactivex.ext.shell.term.Pty ret = io.vertx.reactivex.ext.shell.term.Pty.newInstance((io.vertx.ext.shell.term.Pty)io.vertx.ext.shell.term.Pty.create(terminalType));
    return ret;
  }

  /**
   * Set the standard out handler of the pseudo terminal.
   * @param handler the standard output
   * @return this current object
   */
  public io.vertx.reactivex.ext.shell.term.Pty stdoutHandler(Handler<String> handler) { 
    delegate.stdoutHandler(handler);
    return this;
  }

  /**
   * Write data to the slave standard input of the pseudo terminal.
   * @param data the data to write
   * @return this current object
   */
  public io.vertx.reactivex.ext.shell.term.Pty write(String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * Resize the terminal.
   * @param width 
   * @param height 
   * @return this current object
   */
  public io.vertx.reactivex.ext.shell.term.Pty setSize(int width, int height) { 
    delegate.setSize(width, height);
    return this;
  }

  /**
   * @return the pseudo terminal slave
   */
  public io.vertx.reactivex.ext.shell.term.Tty slave() { 
    io.vertx.reactivex.ext.shell.term.Tty ret = io.vertx.reactivex.ext.shell.term.Tty.newInstance((io.vertx.ext.shell.term.Tty)delegate.slave());
    return ret;
  }

  public static Pty newInstance(io.vertx.ext.shell.term.Pty arg) {
    return arg != null ? new Pty(arg) : null;
  }

}
