/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.rbac;

import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Implementation of the Keycloak RBAC handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC.class)
public class KeycloakRBAC {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KeycloakRBAC that = (KeycloakRBAC) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KeycloakRBAC> __TYPE_ARG = new TypeArg<>(    obj -> new KeycloakRBAC((io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC) obj),
    KeycloakRBAC::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC delegate;
  
  public KeycloakRBAC(io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC delegate) {
    this.delegate = delegate;
  }

  public KeycloakRBAC(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC)delegate;
  }

  public io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC getDelegate() {
    return delegate;
  }

  /**
   * Factory method to create a RBAC handler for tokens adhering to the Keycloak token format.
   * @param options 
   * @return a RBAC validator
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2RBAC create(io.vertx.ext.auth.oauth2.OAuth2ClientOptions options) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2RBAC ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2RBAC.newInstance((io.vertx.ext.auth.oauth2.OAuth2RBAC)io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC.create(options));
    return ret;
  }

  public static KeycloakRBAC newInstance(io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC arg) {
    return arg != null ? new KeycloakRBAC(arg) : null;
  }

}
