/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.it.discovery.service;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.it.discovery.service.HelloService original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rx.RxGen(io.vertx.it.discovery.service.HelloService.class)
public class HelloService {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HelloService that = (HelloService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rx.TypeArg<HelloService> __TYPE_ARG = new io.vertx.lang.rx.TypeArg<>(    obj -> new HelloService((io.vertx.it.discovery.service.HelloService) obj),
    HelloService::getDelegate
  );

  private final io.vertx.it.discovery.service.HelloService delegate;
  
  public HelloService(io.vertx.it.discovery.service.HelloService delegate) {
    this.delegate = delegate;
  }

  public io.vertx.it.discovery.service.HelloService getDelegate() {
    return delegate;
  }

  public void hello(JsonObject name, Handler<AsyncResult<String>> resultHandler) { 
    delegate.hello(name, resultHandler);
  }

  public Single<String> rxHello(JsonObject name) { 
    return io.vertx.reactivex.impl.AsyncResultSingle.toSingle(handler -> {
      hello(name, handler);
    });
  }


  public static  HelloService newInstance(io.vertx.it.discovery.service.HelloService arg) {
    return arg != null ? new HelloService(arg) : null;
  }
}
