/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.oracleclient.OracleClient;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.RowDesc;
import java.util.ArrayList;
import java.util.List;

public class OracleResponse<R> {
    private final int update;
    private List<RS<R>> rs;
    private Row ids;
    private List<RS<R>> output;
    private R empty;

    public OracleResponse(int updateCount) {
        this.update = updateCount;
    }

    public void push(R decodeResultSet, RowDesc desc, int size) {
        if (this.rs == null) {
            this.rs = new ArrayList<RS<R>>();
        }
        this.rs.add(new RS<R>(decodeResultSet, desc, size));
    }

    public void returnedKeys(Row keys) {
        this.ids = keys;
    }

    public void empty(R apply) {
        this.empty = apply;
    }

    public void outputs(R decodeResultSet, RowDesc desc, int size) {
        if (this.output == null) {
            this.output = new ArrayList<RS<R>>();
        }
        this.output.add(new RS<R>(decodeResultSet, desc, size));
    }

    public void handle(QueryResultHandler<R> handler) {
        if (this.rs != null) {
            for (RS<R> rs : this.rs) {
                handler.handleResult(this.update, rs.size, rs.desc, rs.holder, null);
                if (this.ids == null) continue;
                handler.addProperty(OracleClient.GENERATED_KEYS, (Object)this.ids);
            }
        }
        if (this.output != null) {
            for (RS<R> rs : this.output) {
                handler.handleResult(this.update, rs.size, null, rs.holder, null);
                handler.addProperty(OracleClient.OUTPUT, (Object)true);
            }
        }
        if (this.rs == null && this.output == null) {
            handler.handleResult(this.update, -1, null, this.empty, null);
            if (this.ids != null) {
                handler.addProperty(OracleClient.GENERATED_KEYS, (Object)this.ids);
            }
        }
    }

    static class RS<R> {
        R holder;
        int size;
        RowDesc desc;

        RS(R holder, RowDesc desc, int size) {
            this.holder = holder;
            this.desc = desc;
            this.size = size;
        }
    }
}

