/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.oracleclient.impl.FailureUtil;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.CommandResponse;
import java.util.concurrent.Callable;
import java.util.concurrent.Flow;
import oracle.jdbc.OracleConnection;

public abstract class OracleCommand<T> {
    protected final OracleConnection oracleConnection;
    protected final ContextInternal connectionContext;
    private CommandResponse<T> response;

    protected OracleCommand(OracleConnection oracleConnection, ContextInternal connectionContext) {
        this.oracleConnection = oracleConnection;
        this.connectionContext = connectionContext;
    }

    public final Future<Void> processCommand(CommandBase<T> cmd) {
        return this.execute().andThen(ar -> {
            this.response = ar.succeeded() ? CommandResponse.success((Object)ar.result()) : CommandResponse.failure((Throwable)ar.cause());
            this.response.cmd = cmd;
        }).mapEmpty();
    }

    protected abstract Future<T> execute();

    public final <U> Future<U> executeBlocking(Helper.SQLBlockingCodeHandler<U> blockingCodeHandler) {
        return this.connectionContext.executeBlocking(blockingCodeHandler, false);
    }

    public final Future<Void> executeBlocking(Helper.SQLBlockingTaskHandler blockingTaskHandler) {
        return this.connectionContext.executeBlocking((Callable)blockingTaskHandler, false);
    }

    public final <U> Future<U> first(Flow.Publisher<U> publisher) {
        PromiseInternal promise = this.connectionContext.promise();
        publisher.subscribe(new Flow.Subscriber<U>((Promise)promise){
            volatile Flow.Subscription subscription;
            final /* synthetic */ Promise val$promise;
            {
                this.val$promise = promise;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(1L);
            }

            @Override
            public void onNext(U item) {
                this.val$promise.tryComplete(item);
                this.subscription.cancel();
            }

            @Override
            public void onError(Throwable throwable) {
                this.val$promise.fail(FailureUtil.sanitize(throwable));
            }

            @Override
            public void onComplete() {
                this.val$promise.tryComplete(null);
            }
        });
        return promise.future();
    }

    public final void fireResponse() {
        this.response.fire();
    }
}

