/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.oracleclient.OracleClient;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.OracleTestBase;
import tests.oracleclient.junit.OracleRule;

@RunWith(value=VertxUnitRunner.class)
public abstract class OracleGeneratedKeysTestBase
extends OracleTestBase {
    private static final String DROP = "DROP TABLE EntityWithIdentity";
    private static final String CREATE = "CREATE TABLE EntityWithIdentity\n(\n    id             NUMBER(19, 0) GENERATED AS IDENTITY,\n    name           VARCHAR2(255 CHAR),\n    position       NUMBER(10, 0),\n    string         VARCHAR2(255)            DEFAULT 'default'                              NOT NULL,\n    localDate      DATE                     DEFAULT date '2019-11-04'                      NOT NULL,\n    localDateTime  TIMESTAMP                DEFAULT timestamp '2018-11-04 00:00:00'        NOT NULL,\n    inte           NUMBER(10)               DEFAULT 42                                     NOT NULL,\n    longe          NUMBER(19)               DEFAULT 84                                     NOT NULL,\n    floate         BINARY_FLOAT             DEFAULT '42.42'                                NOT NULL,\n    doublee        BINARY_DOUBLE            DEFAULT '84.84'                                NOT NULL,\n    bigDecimal     NUMBER(3, 1)             DEFAULT '4.2'                                  NOT NULL,\n    offsetDateTime TIMESTAMP WITH TIME ZONE DEFAULT timestamp '2019-11-04 00:00:00 +01:02' NOT NULL,\n    PRIMARY KEY (id)\n)";
    private static final String INSERT = "INSERT INTO EntityWithIdentity (name, position) VALUES (?, ?)";
    private static final List<Tuple> GENERATED_COLUMNS = List.of(Tuple.of((Object)"ID", (Object)1), Tuple.of((Object)"STRING", (Object)4, (Object)"default"), Tuple.of((Object)"LOCALDATE", (Object)5, (Object)LocalDateTime.of(2019, 11, 4, 0, 0)), Tuple.of((Object)"LOCALDATETIME", (Object)6, (Object)LocalDateTime.of(2018, 11, 4, 0, 0)), Tuple.of((Object)"INTE", (Object)7, (Object)new BigDecimal("42")), Tuple.of((Object)"LONGE", (Object)8, (Object)new BigDecimal("84")), Tuple.of((Object)"FLOATE", (Object)9, (Object)Float.valueOf(42.42f)), Tuple.of((Object)"DOUBLEE", (Object)10, (Object)84.84), Tuple.of((Object)"BIGDECIMAL", (Object)11, (Object)new BigDecimal("4.2")), Tuple.of((Object)"OFFSETDATETIME", (Object)12, (Object)OffsetDateTime.of(LocalDateTime.of(2019, 11, 4, 0, 0), ZoneOffset.ofHoursMinutes(1, 2))));
    @ClassRule
    public static OracleRule oracle = OracleRule.SHARED_INSTANCE;
    protected Pool pool;

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.pool = OracleBuilder.pool(builder -> builder.connectingTo((SqlConnectOptions)oracle.options()).using(vertx));
        this.pool.withConnection(conn -> conn.query(DROP).execute().otherwiseEmpty().compose(v -> conn.query(CREATE).execute())).onComplete(ctx.asyncAssertSuccess());
    }

    @Test
    public void shouldRetrieveRowId(TestContext ctx) {
        this.doTest(ctx, () -> new OraclePrepareOptions().setAutoGeneratedKeys(true), generated -> {
            Assert.assertNotNull((Object)generated);
            Assert.assertEquals((long)1L, (long)generated.size());
            this.verifyGeneratedId((Row)generated, "ROWID", byte[].class);
        });
    }

    @Test
    public void shouldRetrieveGeneratedKeyByName(TestContext ctx) {
        this.doTest(ctx, () -> {
            JsonArray indexes = GENERATED_COLUMNS.stream().map(tuple -> tuple.getString(0)).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
            return new OraclePrepareOptions().setAutoGeneratedKeysIndexes(indexes);
        }, generated -> {
            Assert.assertNotNull((Object)generated);
            Assert.assertEquals((long)10L, (long)generated.size());
            this.verifyGeneratedId((Row)generated, "ID", Number.class);
            this.verifyGeneratedColumns((Row)generated);
        });
    }

    @Test
    public void shouldRetrieveGeneratedKeyByIndex(TestContext ctx) {
        this.doTest(ctx, () -> {
            JsonArray indexes = GENERATED_COLUMNS.stream().map(tuple -> tuple.getInteger(1)).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
            return new OraclePrepareOptions().setAutoGeneratedKeysIndexes(indexes);
        }, generated -> {
            Assert.assertNotNull((Object)generated);
            Assert.assertEquals((long)10L, (long)generated.size());
            this.verifyGeneratedId((Row)generated, "ID", Number.class);
            this.verifyGeneratedColumns((Row)generated);
        });
    }

    private void doTest(TestContext ctx, Supplier<OraclePrepareOptions> supplier, Consumer<Row> checks) {
        OraclePrepareOptions options = supplier.get();
        this.withSqlClient(client -> client.preparedQuery(INSERT, (PrepareOptions)options).execute(Tuple.of((Object)"bar", (Object)4)), ctx.asyncAssertSuccess(rows -> ctx.verify(v -> checks.accept((Row)rows.property(OracleClient.GENERATED_KEYS)))));
        if (options != null) {
            this.withSqlClient(client -> client.preparedQuery(INSERT, new PrepareOptions(options.toJson())).execute(Tuple.of((Object)"foo", (Object)3)), ctx.asyncAssertSuccess(rows -> ctx.verify(v -> checks.accept((Row)rows.property(OracleClient.GENERATED_KEYS)))));
        }
    }

    protected abstract <T> void withSqlClient(Function<SqlClient, Future<T>> var1, Handler<AsyncResult<T>> var2);

    private void verifyGeneratedId(Row generated, String expectedColumnName, Class<?> expectedClass) {
        Assert.assertEquals((Object)expectedColumnName, (Object)generated.getColumnName(0));
        MatcherAssert.assertThat((Object)generated.getValue(expectedColumnName), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(expectedClass)));
    }

    private void verifyGeneratedColumns(Row generated) {
        for (int i = 1; i < GENERATED_COLUMNS.size(); ++i) {
            Tuple tuple = GENERATED_COLUMNS.get(i);
            Assert.assertEquals((Object)tuple.getString(0), (Object)generated.getColumnName(i));
            Assert.assertEquals((Object)tuple.getValue(2), (Object)generated.getValue(i));
        }
    }

    @After
    public void tearDown(TestContext ctx) throws Exception {
        this.pool.close().onComplete(ctx.asyncAssertSuccess());
    }
}

