/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.oracleclient.OracleException;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnectOptions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.OracleTestBase;
import tests.oracleclient.junit.OracleRule;

@RunWith(value=VertxUnitRunner.class)
public class OracleErrorSimpleTest
extends OracleTestBase {
    @ClassRule
    public static OracleRule oracle = OracleRule.SHARED_INSTANCE;
    Pool pool;

    @Before
    public void setUp() throws Exception {
        this.pool = OracleBuilder.pool(builder -> builder.connectingTo((SqlConnectOptions)oracle.options()).using(vertx));
    }

    @Test
    public void testMetadata(TestContext ctx) {
        this.pool.withConnection(conn -> conn.query("DROP TABLE u_dont_exist").execute()).onComplete(ctx.asyncAssertFailure(t -> {
            if (!(t instanceof OracleException)) {
                Assert.fail((String)t.getClass().getName());
            }
            OracleException e = (OracleException)t;
            Assert.assertEquals((long)0L, (long)e.getStackTrace().length);
            Assert.assertEquals((long)942L, (long)e.getErrorCode());
            Assert.assertEquals((Object)"42000", (Object)e.getSqlState());
            Assert.assertTrue((boolean)t.getMessage().contains("u_dont_exist"));
        }));
    }

    @After
    public void tearDown(TestContext ctx) throws Exception {
        this.pool.close().onComplete(ctx.asyncAssertSuccess());
    }
}

