/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.tests.sqlclient.ProxyServer;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.OracleTestBase;
import tests.oracleclient.junit.OracleRule;

@RunWith(value=VertxUnitRunner.class)
public class OracleBrokenPooledConnectionTest
extends OracleTestBase {
    @ClassRule
    public static OracleRule oracle = OracleRule.SHARED_INSTANCE;
    OracleConnectOptions options = oracle.options();
    Pool pool;

    @After
    public void tearDown(TestContext ctx) throws Exception {
        if (this.pool != null) {
            this.pool.close().onComplete(ctx.asyncAssertSuccess());
        }
    }

    @Test
    public void testBrokenConnectionEvicted(TestContext ctx) {
        ProxyServer proxy = ProxyServer.create((Vertx)vertx, (int)this.options.getPort(), (String)this.options.getHost());
        AtomicReference proxyConn = new AtomicReference();
        proxy.proxyHandler(conn -> {
            proxyConn.set(conn);
            conn.connect();
        });
        this.pool = OracleBuilder.pool(builder -> builder.with(new PoolOptions().setMaxSize(1)).connectingTo((SqlConnectOptions)new OracleConnectOptions(this.options).setPort(8080)).using(vertx));
        proxy.listen(8080, this.options.getHost(), ctx.asyncAssertSuccess(listen -> this.pool.query("SELECT 1 FROM DUAL").execute().onComplete(ctx.asyncAssertSuccess(executed -> {
            ProxyServer.Connection proxyConn1 = (ProxyServer.Connection)proxyConn.get();
            ctx.assertNotNull((Object)proxyConn1);
            Async async = ctx.async();
            proxyConn1.clientCloseHandler(onClose1 -> this.pool.query("SELECT 1 FROM DUAL").execute().onComplete(ctx.asyncAssertFailure(ignored -> this.pool.query("SELECT 1 FROM DUAL").execute().onComplete(ar -> {
                if (ar.succeeded()) {
                    async.complete();
                } else {
                    ctx.fail(ar.cause());
                }
            }))));
            proxyConn1.close();
        }))));
    }
}

