/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.tests.sqlclient.tck.TextDataTypeDecodeTestBase;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.junit.OracleRule;
import tests.oracleclient.tck.ClientConfig;

@RunWith(value=VertxUnitRunner.class)
public class OracleTextDataTypeDecodeTest
extends TextDataTypeDecodeTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    protected JDBCType getNumericJDBCType() {
        return JDBCType.DECIMAL;
    }

    protected Class<? extends Number> getNumericClass() {
        return BigDecimal.class;
    }

    protected Number getNumericValue(Number value) {
        return this.getNumericValue(value.toString());
    }

    protected Number getNumericValue(String value) {
        BigDecimal bd = new BigDecimal(value);
        return bd;
    }

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    public void testSmallInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_2", BigDecimal.class, BigDecimal.valueOf(32767L));
    }

    public void testInteger(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_4", BigDecimal.class, BigDecimal.valueOf(Integer.MAX_VALUE));
    }

    public void testBigInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_8", BigDecimal.class, BigDecimal.valueOf(Long.MAX_VALUE));
    }

    public void testFloat4(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_float_4", Double.class, 3.40282E38);
    }

    @Test
    @Ignore(value="unsupported")
    public void testDouble(TestContext ctx) {
        super.testDouble(ctx);
    }

    public void testNumeric(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_numeric", this.getNumericClass(), this.getNumericValue("999.99"));
    }

    public void testDecimal(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_decimal", this.getNumericClass(), this.getNumericValue("12345"));
    }

    @Test
    @Ignore(value="unsupported")
    public void testBoolean(TestContext ctx) {
        super.testBoolean(ctx);
    }

    public void testDate(TestContext ctx) {
        LocalDateTime expected = LocalDate.of(2019, 1, 1).atStartOfDay();
        this.testDecodeGeneric(ctx, "test_date", OffsetDateTime.class, expected);
    }

    @Test
    @Ignore(value="unsupported")
    public void testTime(TestContext ctx) {
        super.testTime(ctx);
    }
}

