/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.tests.sqlclient.tck.CollectorTestBase;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.junit.OracleRule;
import tests.oracleclient.tck.ClientConfig;

@RunWith(value=VertxUnitRunner.class)
public class OracleCollectorTest
extends CollectorTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    @Test
    public void testSimpleQuery(TestContext ctx) {
        Async async = ctx.async();
        Collector<Row, ?, Map<Integer, TestingCollectorObject>> collector = Collectors.toMap(row -> row.getInteger(0), row -> new TestingCollectorObject(row.getInteger(0), row.getShort(1), row.getInteger(2), row.getLong(3), row.getFloat(4).floatValue(), row.getDouble(5), row.getString(6)));
        TestingCollectorObject expected = new TestingCollectorObject(1, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, 123.456f, 1.234567, "HELLO,WORLD");
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.query("SELECT * FROM test_collector WHERE id = 1").collecting(collector).execute().onComplete(ctx.asyncAssertSuccess(result -> {
            Map map = (Map)result.value();
            TestingCollectorObject actual = (TestingCollectorObject)map.get(1);
            ctx.assertEquals((Object)expected, (Object)actual);
            conn.close();
            async.complete();
        }))));
    }

    @Test
    public void testPreparedQuery(TestContext ctx) {
        Async async = ctx.async();
        Collector<Row, ?, Map<Integer, TestingCollectorObject>> collector = Collectors.toMap(row -> row.getInteger("id"), row -> new TestingCollectorObject(row.getInteger(0), row.getShort(1), row.getInteger(2), row.getLong(3), row.getFloat(4).floatValue(), row.getDouble(5), row.getString(6)));
        TestingCollectorObject expected = new TestingCollectorObject(1, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, 123.456f, 1.234567, "HELLO,WORLD");
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM test_collector WHERE id = 1").collecting(collector).execute().onComplete(ctx.asyncAssertSuccess(result -> {
            Map map = (Map)result.value();
            TestingCollectorObject actual = (TestingCollectorObject)map.get(1);
            ctx.assertEquals((Object)expected, (Object)actual);
            conn.close();
            async.complete();
        }))));
    }

    @Test
    public void testCollectorFailureProvidingSupplier(TestContext ctx) {
        final RuntimeException cause = new RuntimeException();
        this.testCollectorFailure(ctx.async(), ctx, cause, new CollectorBase(){

            @Override
            public Supplier<Object> supplier() {
                throw cause;
            }
        });
    }

    @Test
    public void testCollectorFailureInSupplier(TestContext ctx) {
        final RuntimeException cause = new RuntimeException();
        this.testCollectorFailure(ctx.async(), ctx, cause, new CollectorBase(){

            @Override
            public Supplier<Object> supplier() {
                return () -> {
                    throw cause;
                };
            }
        });
    }

    @Test
    public void testCollectorFailureProvidingAccumulator(TestContext ctx) {
        final RuntimeException cause = new RuntimeException();
        this.testCollectorFailure(ctx.async(), ctx, cause, new CollectorBase(){

            @Override
            public BiConsumer<Object, Row> accumulator() {
                throw cause;
            }
        });
    }

    @Test
    public void testCollectorFailureInAccumulator(TestContext ctx) {
        final RuntimeException cause = new RuntimeException();
        this.testCollectorFailure(ctx.async(), ctx, cause, new CollectorBase(){

            @Override
            public BiConsumer<Object, Row> accumulator() {
                return (o, row) -> {
                    throw cause;
                };
            }
        });
    }

    @Test
    public void testCollectorFailureProvidingFinisher(TestContext ctx) {
        final RuntimeException cause = new RuntimeException();
        this.testCollectorFailure(ctx.async(), ctx, cause, new CollectorBase(){

            @Override
            public Function<Object, Object> finisher() {
                throw cause;
            }
        });
    }

    @Test
    public void testCollectorFailureInFinisher(TestContext ctx) {
        final RuntimeException cause = new RuntimeException();
        this.testCollectorFailure(ctx.async(), ctx, cause, new CollectorBase(){

            @Override
            public Function<Object, Object> finisher() {
                return o -> {
                    throw cause;
                };
            }
        });
    }

    private void testCollectorFailure(Async async, TestContext ctx, Throwable cause, Collector<Row, Object, Object> collector) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.query("SELECT * FROM test_collector WHERE id = 1").collecting(collector).execute().onComplete(ctx.asyncAssertFailure(result -> {
            ctx.assertEquals((Object)cause, result);
            conn.close();
            async.complete();
        }))));
    }

    public void testCollectorRecycle(TestContext ctx) {
        Assume.assumeTrue((boolean)false);
    }

    public void testCollectorNoRecycle(TestContext ctx) {
        Assume.assumeTrue((boolean)false);
    }

    private static class CollectorBase
    implements Collector<Row, Object, Object> {
        private CollectorBase() {
        }

        @Override
        public Supplier<Object> supplier() {
            return () -> null;
        }

        @Override
        public BiConsumer<Object, Row> accumulator() {
            return (a, t) -> {};
        }

        @Override
        public BinaryOperator<Object> combiner() {
            return (a, a2) -> null;
        }

        @Override
        public Function<Object, Object> finisher() {
            return a -> null;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    private static class TestingCollectorObject {
        public int id;
        public short int2;
        public int int4;
        public long int8;
        public float floatNum;
        public double doubleNum;
        public String varchar;

        private TestingCollectorObject(int id, short int2, int int4, long int8, float floatNum, double doubleNum, String varchar) {
            this.id = id;
            this.int2 = int2;
            this.int4 = int4;
            this.int8 = int8;
            this.floatNum = floatNum;
            this.doubleNum = doubleNum;
            this.varchar = varchar;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingCollectorObject that = (TestingCollectorObject)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.int2 != that.int2) {
                return false;
            }
            if (this.int4 != that.int4) {
                return false;
            }
            if (this.int8 != that.int8) {
                return false;
            }
            if (Float.compare(that.floatNum, this.floatNum) != 0) {
                return false;
            }
            if (Double.compare(that.doubleNum, this.doubleNum) != 0) {
                return false;
            }
            return this.varchar != null ? this.varchar.equals(that.varchar) : that.varchar == null;
        }
    }
}

