/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient.junit;

import io.vertx.oracleclient.OracleConnectOptions;
import java.io.IOException;
import java.time.Duration;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.InternetProtocol;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class OracleRule
extends ExternalResource {
    public static final OracleRule SHARED_INSTANCE = new OracleRule();
    private static final String IMAGE = "gvenzl/oracle-free";
    private static final String PASSWORD = "vertx";
    private static final int PORT = 1521;
    private ServerContainer<?> server;
    private OracleConnectOptions options;

    protected void before() throws IOException {
        String connectionUri = System.getProperty("connection.uri");
        if (!this.isNullOrEmpty(connectionUri)) {
            this.options = OracleConnectOptions.fromUri((String)connectionUri);
        } else if (this.server == null) {
            this.options = this.startOracle();
        }
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    protected void after() {
        if (this.isNullOrEmpty(System.getProperty("connection.uri")) && this != SHARED_INSTANCE) {
            this.stopOracle();
        }
    }

    private OracleConnectOptions startOracle() throws IOException {
        String containerVersion = System.getProperty("oracle-container.version");
        containerVersion = this.isNullOrEmpty(containerVersion) ? "23-slim-faststart" : containerVersion;
        String image = "gvenzl/oracle-free:" + containerVersion;
        this.server = (ServerContainer)((ServerContainer)((ServerContainer)((ServerContainer)((ServerContainer)((ServerContainer)new ServerContainer(image).withEnv("ORACLE_PASSWORD", PASSWORD)).withExposedPorts(new Integer[]{1521})).withClasspathResourceMapping("tck/import.sql", "/container-entrypoint-initdb.d/import.sql", BindMode.READ_ONLY)).withLogConsumer(of -> System.out.print("[ORACLE] " + of.getUtf8String()))).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*DATABASE IS READY TO USE!.*\\n", (int)1))).withStartupTimeout(Duration.ofMinutes(15L));
        if (System.getProperties().containsKey("containerFixedPort")) {
            this.server.withFixedExposedPort(1521, 1521);
        }
        this.server.start();
        return new OracleConnectOptions().setHost(this.server.getHost()).setPort(this.server.getMappedPort(1521).intValue()).setUser("sys as sysdba").setPassword(PASSWORD).setDatabase("FREEPDB1");
    }

    private void stopOracle() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
    }

    public OracleConnectOptions options() {
        return new OracleConnectOptions(this.options);
    }

    private static class ServerContainer<SELF extends ServerContainer<SELF>>
    extends GenericContainer<SELF> {
        public ServerContainer(String dockerImageName) {
            super(dockerImageName);
        }

        public SELF withFixedExposedPort(int hostPort, int containerPort) {
            super.addFixedExposedPort(hostPort, containerPort, InternetProtocol.TCP);
            return (SELF)((Object)((ServerContainer)this.self()));
        }
    }
}

