/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.oracleclient.impl.OracleConnectionUriParser;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InvalidOracleConnectionUriParsingTest {
    private final String connectionUri;
    private final BiConsumer<String, Exception> assertions;

    @Parameterized.Parameters(name="{0}: {1}")
    public static Object[][] testData() {
        Object[][] params = new Object[][]{InvalidOracleConnectionUriParsingTest.testData("null uri", null), InvalidOracleConnectionUriParsingTest.testData("uri with invalid scheme", "postgresql://user@?host=localhost&port=1234"), InvalidOracleConnectionUriParsingTest.testData("uri with no separated user/password", "oracle:thin:scott@myhost:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with no separated user/password", "oracle:thin:scott@myhost:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri without password", "oracle:thin:scott/@myhost:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri without user", "oracle:thin:/tiger@myhost:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with multiple user/password splitters", "oracle:thin:scott/tiger/dragon@myhost:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri without net location", "oracle:thin:scott/tiger"), InvalidOracleConnectionUriParsingTest.testData("uri without SID after host", "oracle:thin:scott/tiger@myhost"), InvalidOracleConnectionUriParsingTest.testData("uri without SID after port", "oracle:thin:scott/tiger@myhost:1521"), InvalidOracleConnectionUriParsingTest.testData("uri with empty SID", "oracle:thin:scott/tiger@myhost:1521:"), InvalidOracleConnectionUriParsingTest.testData("uri with invalid content after host", "oracle:thin:@[::1]sss:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with invalid IPv6 address", "oracle:thin:@[:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with empty host", "oracle:thin:@:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with empty IPv6 address", "oracle:thin:@[]:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with empty port", "oracle:thin:@myhost::orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with invalid port", "oracle:thin:@myhost:7654645:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with multiple hosts and ports", "oracle:thin:scott/tiger@myhost1:1521,myhost2:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with multiple hosts", "oracle:thin:scott/tiger@myhost1,myhost2:1521:orcl"), InvalidOracleConnectionUriParsingTest.testData("uri with empty props", "oracle:thin:scott/tiger@myhost:1521:orcl?"), InvalidOracleConnectionUriParsingTest.testData("uri with empty service name", "oracle:thin:scott/tiger@myhost:1521/"), InvalidOracleConnectionUriParsingTest.testData("uri with empty server mode", "oracle:thin:scott/tiger@myhost:1521/orcl:?prop=val"), InvalidOracleConnectionUriParsingTest.testData("uri with invalid server mode", "oracle:thin:scott/tiger@myhost:1521/orcl:foo"), InvalidOracleConnectionUriParsingTest.testData("uri with service name but empty instance name", "oracle:thin:scott/tiger@myhost:1521/orcl/"), InvalidOracleConnectionUriParsingTest.testData("uri with service name and server mode but empty instance name", "oracle:thin:scott/tiger@myhost:1521/orcl:shared/"), InvalidOracleConnectionUriParsingTest.testData("uri with empty prop", "oracle:thin:scott/tiger@myhost:1521:orcl?&prop2"), InvalidOracleConnectionUriParsingTest.testData("uri with prop having no value", "oracle:thin:scott/tiger@myhost:1521:orcl?prop1&prop2=val2"), InvalidOracleConnectionUriParsingTest.testData("uri with ldap syntax", "oracle:thin:@ldap://ldap.acme.com:7777/sales,cn=OracleContext,dc=com", (s, e) -> {
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().toLowerCase(Locale.ENGLISH).contains("ldap"));
        }), InvalidOracleConnectionUriParsingTest.testData("uri with Oracle Net connection descriptor", "oracle:thin:@(DESCRIPTION=\n  (LOAD_BALANCE=on)\n(ADDRESS_LIST=\n  (ADDRESS=(PROTOCOL=TCP)(HOST=host1) (PORT=1521))\n (ADDRESS=(PROTOCOL=TCP)(HOST=host2)(PORT=1521)))\n (CONNECT_DATA=(SERVICE_NAME=service_name)))", (s, e) -> {
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().toLowerCase(Locale.ENGLISH).contains("tns url"));
        }), InvalidOracleConnectionUriParsingTest.testData("uri with empty TNSNames alias", "oracle:thin:@?key=val")};
        return params;
    }

    private static Object[] testData(String testName, String uri) {
        return InvalidOracleConnectionUriParsingTest.testData(testName, uri, null);
    }

    private static Object[] testData(String testName, String uri, BiConsumer<String, Exception> assertions) {
        return new Object[]{testName, uri, assertions};
    }

    public InvalidOracleConnectionUriParsingTest(String name, String connectionUri, BiConsumer<String, Exception> assertions) {
        this.connectionUri = connectionUri;
        this.assertions = assertions;
    }

    @Test
    public void shouldFailToParseInvalidUri() {
        block4: {
            try {
                JsonObject conf = OracleConnectionUriParser.parse((String)this.connectionUri);
                Assert.fail((String)String.format("Should fail to parse: %s\n%s", this.connectionUri, conf.encodePrettily()));
            }
            catch (Exception e) {
                if (this.connectionUri == null) {
                    MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NullPointerException.class)));
                } else {
                    MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class)));
                }
                if (this.assertions == null) break block4;
                this.assertions.accept(this.connectionUri, e);
            }
        }
    }
}

