/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.oracleclient.data.Blob;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.JDBCType;
import java.util.function.Function;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.OracleTestBase;
import tests.oracleclient.junit.OracleRule;

@RunWith(value=VertxUnitRunner.class)
public class OracleBinaryDataTypesTest
extends OracleTestBase {
    @ClassRule
    public static OracleRule oracle = OracleRule.SHARED_INSTANCE;
    Pool pool;

    @Before
    public void setUp() throws Exception {
        this.pool = OracleBuilder.pool(builder -> builder.connectingTo((SqlConnectOptions)oracle.options()).using(vertx));
    }

    @After
    public void tearDown(TestContext ctx) throws Exception {
        this.pool.close().onComplete(ctx.asyncAssertSuccess());
    }

    @Test
    public void testEncodeRaw(TestContext ctx) {
        this.testEncode(ctx, "test_raw", Buffer.buffer((String)"See you space cowboy..."), Buffer::copy);
    }

    @Test
    public void testEncodeBlob(TestContext ctx) {
        this.testEncode(ctx, "test_blob", Buffer.buffer((String)"See you space cowboy..."), Blob::copy);
    }

    private void testEncode(TestContext ctx, String columnName, Buffer expected, Function<Buffer, Object> input) {
        this.pool.preparedQuery("UPDATE binary_data_types SET " + columnName + " = ? WHERE id = 2").execute(Tuple.of((Object)input.apply(expected))).onComplete(ctx.asyncAssertSuccess(updateResult -> this.pool.preparedQuery("SELECT " + columnName + " FROM binary_data_types WHERE id = 2").execute().onComplete(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.size());
            ctx.assertEquals((Object)expected, row.get(Buffer.class, 0));
            ctx.assertEquals((Object)expected, row.get(Buffer.class, columnName));
        }))));
    }

    @Test
    public void testDecodeRaw(TestContext ctx) {
        this.testDecode(ctx, "test_raw", JDBCType.VARBINARY, Buffer.buffer((String)"See you space cowboy..."));
    }

    @Test
    public void testDecodeBlob(TestContext ctx) {
        this.testDecode(ctx, "test_blob", JDBCType.BLOB, Buffer.buffer((String)"See you space cowboy..."));
    }

    private <T> void testDecode(TestContext ctx, String columnName, JDBCType jdbcType, Buffer expected) {
        this.pool.preparedQuery("SELECT " + columnName + " FROM binary_data_types WHERE id = 1").execute().onComplete(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)expected, row.get(Buffer.class, 0));
            ctx.assertEquals((Object)expected, row.get(Buffer.class, columnName));
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)result.columnDescriptors().get(0);
            ctx.assertEquals((Object)jdbcType, (Object)columnDescriptor.jdbcType());
            ctx.assertNotNull((Object)columnDescriptor);
        }));
    }

    private void testDecodeUsingStream(TestContext ctx, String columnName, JDBCType jdbcType, Buffer expected) {
        this.pool.getConnection().onComplete(ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT " + columnName + " FROM binary_data_types WHERE id = 1").onComplete(ctx.asyncAssertSuccess(preparedStatement -> preparedStatement.cursor().read(10).onComplete(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)expected, row.get(Buffer.class, 0));
            ctx.assertEquals((Object)expected, row.get(Buffer.class, columnName));
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)result.columnDescriptors().get(0);
            ctx.assertEquals((Object)jdbcType, (Object)columnDescriptor.jdbcType());
            ctx.assertNotNull((Object)columnDescriptor);
        }))))));
    }

    @Test
    public void testDecodeRawUsingStream(TestContext ctx) {
        this.testDecodeUsingStream(ctx, "test_raw", JDBCType.VARBINARY, Buffer.buffer((String)"See you space cowboy..."));
    }

    @Test
    public void testEncodeNull(TestContext ctx) {
        this.pool.preparedQuery("UPDATE binary_data_types SET test_raw = ?, test_blob = ? WHERE id = 2").execute(Tuple.tuple().addValue(null).addValue(null)).onComplete(ctx.asyncAssertSuccess(updateResult -> this.pool.preparedQuery("SELECT * FROM binary_data_types WHERE id = 2").execute().onComplete(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)3, (Object)row.size());
            ctx.assertEquals((Object)2, (Object)row.getInteger(0));
            for (int i = 1; i < 2; ++i) {
                ctx.assertNull(row.getValue(i));
            }
        }))));
    }

    @Test
    public void testDecodeNull(TestContext ctx) {
        this.pool.preparedQuery("SELECT test_raw, test_blob FROM binary_data_types WHERE id = 3").execute().onComplete(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)2, (Object)row.size());
            for (int i = 0; i < 2; ++i) {
                ctx.assertNull(row.getValue(i));
            }
        }));
    }
}

