/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import io.vertx.tests.sqlclient.tck.BinaryDataTypeEncodeTestBase;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.function.BiFunction;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.junit.OracleRule;
import tests.oracleclient.tck.ClientConfig;

@RunWith(value=VertxUnitRunner.class)
public class OracleBinaryDataTypeEncodeTest
extends BinaryDataTypeEncodeTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    protected JDBCType getNumericJDBCType() {
        return JDBCType.NUMERIC;
    }

    protected Class<? extends Number> getNumericClass() {
        return BigDecimal.class;
    }

    protected Number getNumericValue(Number value) {
        return this.getNumericValue(value.toString());
    }

    protected Number getNumericValue(String value) {
        return new BigDecimal(value);
    }

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    protected String statement(String ... parts) {
        return String.join((CharSequence)" ?", parts);
    }

    public void testSmallInt(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_2", BigDecimal.class, null, BigDecimal.valueOf(-32768L));
    }

    public void testInteger(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_4", BigDecimal.class, null, BigDecimal.valueOf(Integer.MIN_VALUE));
    }

    public void testBigInt(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_8", BigDecimal.class, null, BigDecimal.valueOf(Long.MIN_VALUE));
    }

    public void testFloat4(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_float_4", Double.class, null, -3.402823E38);
    }

    @Test
    @Ignore(value="unsupported")
    public void testDouble(TestContext ctx) {
        super.testDouble(ctx);
    }

    public void testChar(TestContext ctx) {
        super.testChar(ctx);
    }

    public void testVarchar(TestContext ctx) {
        super.testVarchar(ctx);
    }

    @Test
    @Ignore(value="unsupported")
    public void testBoolean(TestContext ctx) {
        super.testBoolean(ctx);
    }

    public void testDate(TestContext ctx) {
        LocalDateTime expected = LocalDate.parse("1999-12-31").atStartOfDay();
        this.testEncodeGeneric(ctx, "test_date", LocalDateTime.class, null, expected);
    }

    @Test
    @Ignore(value="unsupported")
    public void testTime(TestContext ctx) {
        super.testTime(ctx);
    }

    @Test
    @Ignore(value="unsupported")
    public void testNullValues(TestContext ctx) {
        super.testNullValues(ctx);
    }

    protected <T> void testEncodeGeneric(TestContext ctx, String columnName, Class<? extends T> clazz, BiFunction<Row, String, T> getter, T expected) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("UPDATE basicdatatype SET " + columnName + " = ", " WHERE id = 2")).execute(Tuple.tuple().addValue(expected)).onComplete(ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT " + columnName + " FROM basicdatatype WHERE id = 2").execute().onComplete(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.size());
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
            if (getter != null) {
                ctx.assertEquals(expected, getter.apply(row, columnName));
            }
            conn.close();
        }))))));
    }
}

