/*
 * Decompiled with CFR 0.152.
 */
package tests.oracleclient;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import tests.oracleclient.OracleTestBase;
import tests.oracleclient.junit.OracleRule;

@RunWith(value=VertxUnitRunner.class)
public class OracleColumnDescriptorTest
extends OracleTestBase {
    @ClassRule
    public static OracleRule oracle = OracleRule.SHARED_INSTANCE;
    Pool pool;

    @Before
    public void setUp() throws Exception {
        this.pool = OracleBuilder.pool(builder -> builder.connectingTo((SqlConnectOptions)oracle.options()).using(vertx));
    }

    @Test
    public void testMetadata(TestContext ctx) {
        this.pool.withConnection(conn -> conn.query("SELECT id, val FROM mutable").execute()).onComplete(ctx.asyncAssertSuccess(rows -> {
            ctx.assertNotNull((Object)rows.columnDescriptors());
            ctx.assertNotNull((Object)rows.columnsNames());
            ctx.assertEquals((Object)"ID", rows.columnsNames().get(0));
            ctx.assertEquals((Object)"VAL", rows.columnsNames().get(1));
            ctx.assertEquals((Object)2, (Object)rows.columnDescriptors().size());
            ctx.assertEquals((Object)"NUMBER", (Object)((ColumnDescriptor)rows.columnDescriptors().get(0)).typeName());
            ctx.assertEquals((Object)"VARCHAR2", (Object)((ColumnDescriptor)rows.columnDescriptors().get(1)).typeName());
        }));
    }

    @After
    public void tearDown(TestContext ctx) throws Exception {
        this.pool.close().onComplete(ctx.asyncAssertSuccess());
    }
}

