/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.FailureUtil;
import io.vertx.oracleclient.impl.commands.OracleQueryCommand;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.TupleInternal;
import io.vertx.sqlclient.internal.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class OraclePreparedBatchQuery<C, R>
extends OracleQueryCommand<C, R> {
    private final String sql;
    private final List<TupleInternal> listParams;
    private final QueryResultHandler<R> resultHandler;

    public OraclePreparedBatchQuery(OracleConnection oracleConnection, ContextInternal connectionContext, ExtendedQueryCommand<R> cmd, Collector<Row, C, R> collector) {
        super(oracleConnection, connectionContext, collector);
        this.sql = cmd.sql();
        this.listParams = cmd.paramsList();
        this.resultHandler = cmd.resultHandler();
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return null;
    }

    @Override
    protected boolean returnAutoGeneratedKeys(Connection conn, OraclePrepareOptions options) {
        return false;
    }

    @Override
    protected String query() {
        return this.sql;
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (Tuple tuple : this.listParams) {
            for (int i = 0; i < tuple.size(); ++i) {
                Object value = this.adaptType(conn, tuple.getValue(i));
                ps.setObject(i + 1, value);
            }
            ps.addBatch();
        }
    }

    @Override
    protected Future<Boolean> doExecute(OraclePreparedStatement ps, boolean returnAutoGeneratedKeys) {
        return this.executeBlocking(() -> ((OraclePreparedStatement)ps).executeBatchAsyncOracle()).compose(pub -> this.collect((Flow.Publisher)pub)).map(list -> {
            int[] res = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                res[i] = ((Long)list.get(i)).intValue();
            }
            return res;
        }).compose(returnedBatchResult -> this.executeBlocking(() -> this.decode((Statement)ps, (int[])returnedBatchResult, returnAutoGeneratedKeys))).map(oracleResponse -> {
            oracleResponse.handle(this.resultHandler);
            return false;
        });
    }

    private <T> Future<List<T>> collect(Flow.Publisher<T> publisher) {
        PromiseInternal promise = this.connectionContext.promise();
        publisher.subscribe(new Flow.Subscriber<T>((Promise)promise){
            final List<T> list = Collections.synchronizedList(new ArrayList());
            final /* synthetic */ Promise val$promise;
            {
                this.val$promise = promise;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T item) {
                this.list.add(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.val$promise.fail(FailureUtil.sanitize(throwable));
            }

            @Override
            public void onComplete() {
                this.val$promise.complete(this.list);
            }
        });
        return promise.future();
    }
}

