/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.oracleclient.OracleException;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleRow;
import io.vertx.oracleclient.impl.OracleRowDesc;
import io.vertx.oracleclient.impl.commands.OraclePreparedQueryCommand;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.internal.RowDesc;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import oracle.jdbc.OracleResultSet;

public class RowReader<C, R>
implements Flow.Subscriber<Row>,
Function<oracle.jdbc.OracleRow, Row> {
    private static final Logger LOG = LoggerFactory.getLogger(RowReader.class);
    private final ContextInternal context;
    private final List<String> types;
    private final RowDesc description;
    private final Statement resultSetStatement;
    private final Collector<Row, C, R> collector;
    private Flow.Subscription subscription;
    private Promise<OracleResponse<R>> readPromise;
    private ArrayDeque<Row> queue;
    private int fetchSize;
    private Promise<Void> closePromise;

    public RowReader(ContextInternal context, Collector<Row, C, R> collector, OracleResultSet ors) throws SQLException {
        this.context = context;
        this.collector = collector;
        this.resultSetStatement = ors.getStatement();
        ResultSetMetaData metaData = ors.getMetaData();
        int cols = metaData.getColumnCount();
        this.types = new ArrayList<String>(cols);
        for (int i = 1; i <= cols; ++i) {
            this.types.add(metaData.getColumnClassName(i));
        }
        Flow.Publisher publisher = ors.publisherOracle((Function)this);
        this.description = OracleRowDesc.create(metaData);
        publisher.subscribe(this);
    }

    @Override
    public void onSubscribe(Flow.Subscription sub) {
        this.context.runOnContext(v -> {
            if (this.closePromise != null) {
                sub.cancel();
                return;
            }
            this.subscription = sub;
        });
    }

    public Future<OracleResponse<R>> read(int fetchSize) {
        PromiseInternal promise = this.context.owner().promise();
        this.context.runOnContext(arg_0 -> this.lambda$read$3((Promise)promise, fetchSize, arg_0));
        return promise.future();
    }

    @Override
    public void onNext(Row item) {
        this.context.runOnContext(v -> {
            if (this.closePromise != null) {
                return;
            }
            this.queue.add(item);
            if (this.queue.size() > this.fetchSize) {
                OracleResponse<R> response = this.createResponse();
                this.readPromise.complete(response);
                this.readPromise = null;
            }
        });
    }

    @Override
    public void onError(Throwable throwable) {
        this.context.runOnContext(v -> {
            if (this.closePromise != null) {
                LOG.trace((Object)"Dropping subscription failure", throwable);
                return;
            }
            this.closePromise = this.context.promise();
            Helper.executeBlocking((Context)this.context, () -> Helper.closeQuietly(this.resultSetStatement)).otherwiseEmpty().onComplete(this.closePromise);
            this.readPromise.fail(throwable);
        });
    }

    @Override
    public void onComplete() {
        this.context.runOnContext(v -> {
            if (this.closePromise != null) {
                return;
            }
            this.closePromise = this.context.promise();
            Helper.executeBlocking((Context)this.context, () -> Helper.closeQuietly(this.resultSetStatement)).otherwiseEmpty().onComplete(this.closePromise);
            OracleResponse<R> response = this.createResponse();
            this.queue = null;
            this.readPromise.complete(response);
        });
    }

    private OracleResponse<R> createResponse() {
        Row row;
        int size;
        OracleResponse<R> response = new OracleResponse<R>(-1);
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        C container = this.collector.supplier().get();
        for (size = 0; size < this.fetchSize && (row = this.queue.poll()) != null; ++size) {
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), this.description, size);
        return response;
    }

    @Override
    public Row apply(oracle.jdbc.OracleRow oracleRow) {
        try {
            return RowReader.transform(this.types, this.description, oracleRow);
        }
        catch (SQLException e) {
            throw new OracleException(e);
        }
    }

    private static Row transform(List<String> ors, RowDesc desc, oracle.jdbc.OracleRow or) throws SQLException {
        OracleRow row = new OracleRow(desc);
        for (int i = 1; i <= desc.columnNames().size(); ++i) {
            Object res = Helper.convertSqlValue(or.getObject(i, RowReader.getType(ors.get(i - 1))));
            row.addValue(res);
        }
        return row;
    }

    private static Class<?> getType(String cn) {
        try {
            return OraclePreparedQueryCommand.class.getClassLoader().loadClass(cn);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Future<Void> close() {
        PromiseInternal promise = this.context.owner().promise();
        this.context.runOnContext(arg_0 -> this.lambda$close$10((Promise)promise, arg_0));
        return promise.future();
    }

    public Future<Boolean> hasMore() {
        PromiseInternal promise = this.context.owner().promise();
        this.context.runOnContext(arg_0 -> this.lambda$hasMore$11((Promise)promise, arg_0));
        return promise.future();
    }

    private /* synthetic */ void lambda$hasMore$11(Promise promise, Void v) {
        promise.complete((Object)(this.queue != null && !this.queue.isEmpty() ? 1 : 0));
    }

    private /* synthetic */ void lambda$close$10(Promise promise, Void v) {
        if (this.closePromise != null) {
            this.closePromise.future().onComplete((Completable)promise);
            return;
        }
        this.closePromise = this.context.promise();
        this.closePromise.future().onComplete((Completable)promise);
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        if (this.readPromise != null) {
            this.readPromise.fail("Subscription has been canceled");
        }
        Helper.executeBlocking((Context)this.context, () -> Helper.closeQuietly(this.resultSetStatement)).otherwiseEmpty().onComplete(this.closePromise);
    }

    private /* synthetic */ void lambda$read$3(Promise promise, int fetchSize, Void v) {
        if (this.closePromise != null) {
            promise.fail("RowReader is closed");
            return;
        }
        if (this.subscription == null) {
            promise.fail("Subscription is not ready yet");
            return;
        }
        if (this.readPromise != null) {
            promise.fail("Read is already in progress");
            return;
        }
        this.fetchSize = fetchSize;
        this.readPromise = this.context.promise();
        if (this.queue == null) {
            this.queue = new ArrayDeque(fetchSize + 1);
            Helper.executeBlocking((Context)this.context, () -> this.subscription.request(fetchSize + 1));
        } else {
            Helper.executeBlocking((Context)this.context, () -> this.subscription.request(fetchSize));
        }
        this.readPromise.future().onComplete((Completable)promise);
    }
}

