/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleMetadata;
import io.vertx.oracleclient.impl.RowReader;
import io.vertx.oracleclient.impl.commands.OracleCloseConnectionCommand;
import io.vertx.oracleclient.impl.commands.OracleCloseCursorCommand;
import io.vertx.oracleclient.impl.commands.OracleCloseStatementCommand;
import io.vertx.oracleclient.impl.commands.OracleCommand;
import io.vertx.oracleclient.impl.commands.OracleCursorFetchCommand;
import io.vertx.oracleclient.impl.commands.OracleCursorQueryCommand;
import io.vertx.oracleclient.impl.commands.OraclePrepareStatementCommand;
import io.vertx.oracleclient.impl.commands.OraclePreparedBatchQuery;
import io.vertx.oracleclient.impl.commands.OraclePreparedQueryCommand;
import io.vertx.oracleclient.impl.commands.OracleSimpleQueryCommand;
import io.vertx.oracleclient.impl.commands.OracleTransactionCommand;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.command.CloseConnectionCommand;
import io.vertx.sqlclient.internal.command.CloseCursorCommand;
import io.vertx.sqlclient.internal.command.CloseStatementCommand;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.ExtendedQueryCommand;
import io.vertx.sqlclient.internal.command.PrepareStatementCommand;
import io.vertx.sqlclient.internal.command.SimpleQueryCommand;
import io.vertx.sqlclient.internal.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.jdbc.OracleConnection;

public class OracleJdbcConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(OracleJdbcConnection.class);
    private final ClientMetrics metrics;
    private final OracleConnection connection;
    private final OracleMetadata metadata;
    private final ContextInternal context;
    private final OracleConnectOptions options;
    private final ConcurrentMap<String, RowReader> cursors = new ConcurrentHashMap<String, RowReader>();
    private Connection.Holder holder;
    private final Deque<CommandBase> pending = new ArrayDeque<CommandBase>();
    private Promise<Void> closePromise;
    private boolean inflight;
    private boolean executing;

    public OracleJdbcConnection(ContextInternal ctx, ClientMetrics metrics, OracleConnectOptions options, OracleConnection oc, OracleMetadata metadata) {
        this.context = ctx;
        this.metrics = metrics;
        this.options = options;
        this.connection = oc;
        this.metadata = metadata;
    }

    public ClientMetrics metrics() {
        return this.metrics;
    }

    public int pipeliningLimit() {
        return 1;
    }

    public TracingPolicy tracingPolicy() {
        return this.options.getTracingPolicy();
    }

    public String system() {
        return "oracle";
    }

    public String database() {
        return this.options.getDatabase();
    }

    public String user() {
        return this.options.getUser();
    }

    public SocketAddress server() {
        return this.options.getSocketAddress();
    }

    public void init(Connection.Holder holder) {
        this.holder = holder;
    }

    public boolean isSsl() {
        return this.options.isSsl();
    }

    public boolean isValid() {
        try {
            return this.connection.isValid(OracleConnection.ConnectionValidation.NONE, 0);
        }
        catch (SQLException e) {
            log.trace((Object)"Failed to validate connection", (Throwable)e);
            return false;
        }
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.metadata;
    }

    public void close(Connection.Holder holder, Promise<Void> promise) {
        if (Vertx.currentContext() == this.context) {
            Future future;
            if (this.closePromise == null) {
                this.closePromise = this.context.promise();
                future = this.closePromise.future().andThen(ar -> holder.handleClosed());
                this.pending.add((CommandBase)CloseConnectionCommand.INSTANCE);
                this.checkPending();
            } else {
                future = this.closePromise.future();
            }
            future.onComplete(promise);
        } else {
            this.context.runOnContext(v -> this.close(holder, promise));
        }
    }

    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    public Future<Void> afterAcquire() {
        PromiseInternal promise = this.context.owner().promise();
        this.context.executeBlocking(() -> {
            this.connection.beginRequest();
            return null;
        }, false).onComplete((Completable)promise);
        return promise.future();
    }

    public Future<Void> beforeRecycle() {
        PromiseInternal promise = this.context.owner().promise();
        this.context.executeBlocking(() -> {
            this.connection.endRequest();
            return null;
        }, false).onComplete((Completable)promise);
        return promise.future();
    }

    public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
        PromiseInternal promise = context.promise();
        this.context.emit(arg_0 -> this.lambda$schedule$4(cmd, (Promise)promise, arg_0));
        return promise.future();
    }

    private <R> void doSchedule(CommandBase<R> cmd, Completable<R> handler) {
        cmd.handler = handler;
        if (this.closePromise == null) {
            this.pending.add(cmd);
            this.checkPending();
        } else {
            cmd.fail((Throwable)VertxException.noStackTrace((String)"Connection is no longer active"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPending() {
        if (this.executing) {
            return;
        }
        try {
            CommandBase cmd;
            this.executing = true;
            while (!this.inflight && (cmd = this.pending.poll()) != null) {
                this.inflight = true;
                if (this.metrics != null && cmd instanceof CloseConnectionCommand) {
                    this.metrics.close();
                }
                OracleCommand action = this.wrap(cmd);
                Future<Void> future = action.processCommand(cmd);
                CommandBase capture = cmd;
                future.onComplete(ar -> this.actionComplete(capture, action, (AsyncResult<Void>)ar));
            }
        }
        finally {
            this.executing = false;
        }
    }

    private OracleCommand wrap(CommandBase cmd) {
        OracleCommand action;
        if (cmd instanceof SimpleQueryCommand) {
            action = OracleSimpleQueryCommand.create(this.connection, this.context, (SimpleQueryCommand)cmd);
        } else if (cmd instanceof PrepareStatementCommand) {
            action = new OraclePrepareStatementCommand(this.connection, this.context, (PrepareStatementCommand)cmd);
        } else if (cmd instanceof ExtendedQueryCommand) {
            action = this.forExtendedQuery((ExtendedQueryCommand)cmd);
        } else if (cmd instanceof TxCommand) {
            action = OracleTransactionCommand.create(this.connection, this.context, (TxCommand)cmd);
        } else if (cmd instanceof CloseStatementCommand) {
            action = new OracleCloseStatementCommand(this.connection, this.context);
        } else if (cmd instanceof CloseCursorCommand) {
            CloseCursorCommand closeCursorCommand = (CloseCursorCommand)cmd;
            RowReader reader = (RowReader)this.cursors.remove(closeCursorCommand.id());
            action = new OracleCloseCursorCommand(this.connection, this.context, reader);
        } else if (cmd instanceof CloseConnectionCommand) {
            action = new OracleCloseConnectionCommand(this.connection, this.context, this.closePromise);
        } else {
            throw new UnsupportedOperationException(cmd.getClass().getName());
        }
        return action;
    }

    private OracleCommand forExtendedQuery(ExtendedQueryCommand cmd) {
        RowReader rowReader;
        String cursorId = cmd.cursorId();
        OracleCommand action = cursorId != null ? ((rowReader = (RowReader)this.cursors.get(cursorId)) != null ? OracleCursorFetchCommand.create(this.connection, this.context, cmd, rowReader) : OracleCursorQueryCommand.create(this.connection, this.context, cmd, cmd.collector(), rr -> this.cursors.put(cursorId, (RowReader)rr))) : (cmd.isBatch() ? new OraclePreparedBatchQuery(this.connection, this.context, cmd, cmd.collector()) : new OraclePreparedQueryCommand(this.connection, this.context, cmd, cmd.collector()));
        return action;
    }

    private void actionComplete(CommandBase cmd, OracleCommand<?> action, AsyncResult<Void> ar) {
        SQLException sqlException;
        Throwable cause;
        this.inflight = false;
        Future future = Future.succeededFuture();
        if (ar.failed() && ((cause = ar.cause()) instanceof SQLException || (cause = cause.getCause()) instanceof SQLException) && Helper.isFatal(sqlException = (SQLException)cause)) {
            PromiseInternal promise = this.context.promise();
            this.close(this.holder, (Promise<Void>)promise);
            future = promise.future();
        }
        future.onComplete(ignored -> {
            action.fireResponse();
            this.checkPending();
        });
    }

    private /* synthetic */ void lambda$schedule$4(CommandBase cmd, Promise promise, Void v) {
        this.doSchedule((CommandBase)cmd, (Completable)promise);
    }
}

