/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.tck.TransactionTestBase;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OracleTransactionTest
extends TransactionTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    protected Pool createPool() {
        return OracleBuilder.pool(builder -> builder.with(new PoolOptions().setMaxSize(1)).connectingTo((SqlConnectOptions)rule.options()).using(this.vertx));
    }

    protected Pool nonTxPool() {
        return OracleBuilder.pool(builder -> builder.with(new PoolOptions().setMaxSize(1)).connectingTo((SqlConnectOptions)rule.options()).using(this.vertx));
    }

    protected String statement(String ... parts) {
        return String.join((CharSequence)" ?", parts);
    }

    @Test
    public void testTransactionsInConsecutiveConnectionAcquisitions(TestContext ctx) {
        Pool pool = this.getPool();
        pool.query("TRUNCATE TABLE mutable").execute().mapEmpty().compose(v -> pool.withTransaction(client -> client.query("INSERT INTO mutable (id,val) VALUES (1,'bim')").execute().mapEmpty())).compose(v -> pool.withConnection(client -> client.query("DELETE FROM mutable WHERE id = 1").execute().mapEmpty())).compose(v -> pool.withTransaction(client -> client.query("SELECT 1 FROM DUAL").execute().mapEmpty())).onComplete(ctx.asyncAssertSuccess());
    }

    @Test
    public void testTransactionDoNotLeaveOpenCursors(TestContext ctx) {
        int count = 5000;
        Async async = ctx.async(count);
        for (int i = 0; i < count; ++i) {
            this.pool.withTransaction(conn -> conn.query("SELECT 1 FROM DUAL").execute()).onComplete(ctx.asyncAssertSuccess(v -> async.countDown()));
        }
    }

    @Test
    public void testConstraintViolationIsReported(TestContext ctx) {
        this.pool.withConnection(conn -> {
            String sql = "INSERT INTO passenger (nif, name, last_name, contact_number, created_at, address_id)\nVALUES (null, 'Walt', 'White', '+34608554433', 1691060927694, 2)";
            return conn.preparedQuery(sql, (PrepareOptions)new OraclePrepareOptions().setAutoGeneratedKeys(true)).execute();
        }).onComplete(ctx.asyncAssertFailure());
    }
}

