/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.oracleclient.test.tck.ClientConfig;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.tck.BinaryDataTypeDecodeTestBase;
import java.math.BigDecimal;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OracleBinaryDataTypeDecodeTest
extends BinaryDataTypeDecodeTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    protected JDBCType getNumericJDBCType() {
        return JDBCType.NUMERIC;
    }

    protected Class<? extends Number> getNumericClass() {
        return BigDecimal.class;
    }

    protected Number getNumericValue(Number value) {
        return this.getNumericValue(value.toString());
    }

    protected Number getNumericValue(String value) {
        return new BigDecimal(value);
    }

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    public void testSmallInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_2", BigDecimal.class, JDBCType.NUMERIC, BigDecimal.valueOf(32767L));
    }

    public void testInteger(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_4", BigDecimal.class, JDBCType.NUMERIC, BigDecimal.valueOf(Integer.MAX_VALUE));
    }

    public void testBigInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_8", BigDecimal.class, JDBCType.NUMERIC, BigDecimal.valueOf(Long.MAX_VALUE));
    }

    public void testFloat4(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_float_4", Double.class, JDBCType.FLOAT, 3.40282E38);
    }

    @Test
    @Ignore(value="unsupported")
    public void testDouble(TestContext ctx) {
        super.testDouble(ctx);
    }

    @Test
    @Ignore(value="unsupported")
    public void testBoolean(TestContext ctx) {
        super.testBoolean(ctx);
    }

    public void testChar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_char", String.class, JDBCType.CHAR, "testchar");
    }

    public void testDate(TestContext ctx) {
        LocalDateTime expected = LocalDate.of(2019, 1, 1).atStartOfDay();
        this.testDecodeGeneric(ctx, "test_date", LocalDate.class, JDBCType.TIMESTAMP, expected);
    }

    @Test
    @Ignore(value="unsupported")
    public void testTime(TestContext ctx) {
        super.testTime(ctx);
    }

    @Test
    @Ignore(value="unsupported")
    public void testNullValues(TestContext ctx) {
        super.testNullValues(ctx);
    }

    @Test
    @Ignore(value="unsupported")
    public void testSelectAll(TestContext ctx) {
        super.testSelectAll(ctx);
    }

    @Test
    @Ignore(value="unsupported")
    public void testToJsonObject(TestContext ctx) {
        super.testToJsonObject(ctx);
    }
}

