/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.oracleclient.test.OracleTestBase;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.JDBCType;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OracleQueriesTest
extends OracleTestBase {
    @ClassRule
    public static OracleRule oracle = OracleRule.SHARED_INSTANCE;
    Pool pool;

    @Before
    public void setUp() throws Exception {
        this.pool = OracleBuilder.pool(builder -> builder.connectingTo((SqlConnectOptions)oracle.options()).using(vertx));
    }

    @Test
    public void testCurrentTimestampType(TestContext ctx) {
        this.pool.query("SELECT CURRENT_TIMESTAMP FROM dual").execute().onComplete(ctx.asyncAssertSuccess(rows -> ctx.verify(v -> {
            Assert.assertEquals((long)1L, (long)rows.size());
            Object value = ((Row)rows.iterator().next()).getValue(0);
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(OffsetDateTime.class)));
            Assert.assertEquals((long)0L, (long)ChronoUnit.MINUTES.between((OffsetDateTime)value, OffsetDateTime.now()));
            ColumnDescriptor descriptor = (ColumnDescriptor)rows.columnDescriptors().get(0);
            ctx.assertEquals((Object)"TIMESTAMP WITH TIME ZONE", (Object)descriptor.typeName());
            ctx.assertEquals((Object)JDBCType.TIMESTAMP_WITH_TIMEZONE, (Object)descriptor.jdbcType());
        })));
    }

    @Test
    public void testInsertSelectQuery(TestContext ctx) {
        this.pool.query("TRUNCATE TABLE mutable").execute().otherwiseEmpty().compose(v -> this.pool.withConnection(conn -> {
            String sql = "INSERT INTO mutable (id, val) SELECT id, message FROM immutable WHERE id IN (?,?)";
            return conn.preparedQuery(sql).execute(Tuple.of((Object)9, (Object)7));
        })).onComplete(ctx.asyncAssertSuccess());
    }

    @After
    public void tearDown(TestContext ctx) throws Exception {
        this.pool.close().onComplete(ctx.asyncAssertSuccess());
    }
}

