/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.oracleclient.OracleBuilder;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OracleConnection;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;

public enum ClientConfig {
    CONNECT{

        Connector<SqlConnection> connect(final Vertx vertx, final SqlConnectOptions options) {
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    OracleConnection.connect((Vertx)vertx, (OracleConnectOptions)new OracleConnectOptions(options), ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)((SqlConnection)ar.result())));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                }
            };
        }
    }
    ,
    POOLED{

        Connector<SqlConnection> connect(Vertx vertx, SqlConnectOptions options) {
            final Pool pool = OracleBuilder.pool(builder -> builder.with(new PoolOptions().setMaxSize(5)).connectingTo((SqlConnectOptions)new OracleConnectOptions(options)).using(vertx));
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    pool.getConnection(ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)((SqlConnection)ar.result())));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                    pool.close();
                }
            };
        }
    };


    abstract <C extends SqlClient> Connector<C> connect(Vertx var1, SqlConnectOptions var2);
}

