/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.oracleclient.test.OracleTestBase;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OraclePoolTest
extends OracleTestBase {
    @ClassRule
    public static OracleRule oracle = OracleRule.SHARED_INSTANCE;
    private OracleConnectOptions options;
    private Set<OraclePool> pools;

    @Before
    public void setUp() throws Exception {
        this.options = oracle.options();
        this.pools = Collections.synchronizedSet(new HashSet());
    }

    @After
    public void tearDown(TestContext ctx) throws Exception {
        if (!this.pools.isEmpty()) {
            Async async = ctx.async(this.pools.size());
            for (OraclePool pool : this.pools) {
                pool.close(ar -> async.countDown());
            }
            async.await();
        }
    }

    private OraclePool createPool(OracleConnectOptions connectOptions, int size) {
        return this.createPool(connectOptions, new PoolOptions().setMaxSize(size));
    }

    private OraclePool createPool(OracleConnectOptions connectOptions, PoolOptions poolOptions) {
        OracleConnectOptions co = new OracleConnectOptions(connectOptions);
        PoolOptions po = new PoolOptions(poolOptions);
        OraclePool pool = OraclePool.pool((Vertx)vertx, (OracleConnectOptions)co, (PoolOptions)po);
        this.pools.add(pool);
        return pool;
    }

    @Test
    public void testPool(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        OraclePool pool = this.createPool(this.options, 40);
        for (int i = 0; i < num; ++i) {
            pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, randomnumber FROM WORLD").execute(ctx.asyncAssertSuccess(rows -> {
                ctx.assertEquals((Object)100, (Object)rows.size());
                conn.close();
                async.countDown();
            }))));
        }
    }

    @Test
    public void testQuery(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        OraclePool pool = this.createPool(this.options, 40);
        for (int i = 0; i < num; ++i) {
            pool.query("SELECT id, randomnumber FROM WORLD").execute(ctx.asyncAssertSuccess(rows -> {
                ctx.assertEquals((Object)100, (Object)rows.size());
                async.countDown();
            }));
        }
    }

    @Test
    public void testQueryWithParams(TestContext ctx) {
        int num = 2;
        Async async = ctx.async(num);
        OraclePool pool = this.createPool(this.options, 1);
        for (int i = 0; i < num; ++i) {
            PreparedQuery preparedQuery = pool.preparedQuery("SELECT id, randomnumber FROM WORLD WHERE id=?");
            preparedQuery.execute(Tuple.of((Object)(i + 1)), ctx.asyncAssertSuccess(rows -> {
                ctx.assertEquals((Object)1, (Object)rows.size());
                async.countDown();
            }));
        }
    }

    @Test
    public void testUpdate(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        OraclePool pool = this.createPool(this.options, 4);
        for (int i = 0; i < num; ++i) {
            pool.query("UPDATE Fortune SET message = 'Whatever' WHERE id = 9").execute(ctx.asyncAssertSuccess(rows -> {
                ctx.assertEquals((Object)1, (Object)rows.rowCount());
                async.countDown();
            }));
        }
    }

    @Test
    public void testUpdateWithParams(TestContext ctx) {
        int num = 1000;
        Async async = ctx.async(num);
        OraclePool pool = this.createPool(this.options, 4);
        for (int i = 0; i < num; ++i) {
            pool.preparedQuery("UPDATE Fortune SET message = 'Whatever' WHERE id = ?").execute(Tuple.of((Object)9), ar -> {
                if (ar.succeeded()) {
                    RowSet result = (RowSet)ar.result();
                    ctx.assertEquals((Object)1, (Object)result.rowCount());
                } else {
                    ctx.assertEquals((Object)"closed", (Object)ar.cause().getMessage());
                }
                async.countDown();
            });
        }
    }

    @Test
    public void testWithConnection(TestContext ctx) {
        Async async = ctx.async(10);
        OraclePool pool = this.createPool(this.options, 1);
        Function<SqlConnection, Future> success = conn -> conn.query("SELECT 1 FROM DUAL").execute();
        Function<SqlConnection, Future> failure = conn -> conn.query("SELECT 1 FROM does_not_exist").execute();
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                pool.withConnection(success, ctx.asyncAssertSuccess(v -> async.countDown()));
                continue;
            }
            pool.withConnection(failure, ctx.asyncAssertFailure(v -> async.countDown()));
        }
    }

    @Test
    public void testAuthFailure(TestContext ctx) {
        Async async = ctx.async();
        OraclePool pool = this.createPool(new OracleConnectOptions(this.options).setPassword("wrong"), 1);
        pool.query("SELECT id, randomnumber FROM WORLD").execute(ctx.asyncAssertFailure(v2 -> async.complete()));
    }

    @Test
    public void testRunWithExisting(TestContext ctx) {
        Async async = ctx.async();
        vertx.runOnContext(v -> {
            try {
                OraclePool.pool((OracleConnectOptions)this.options, (PoolOptions)new PoolOptions());
                ctx.fail();
            }
            catch (IllegalStateException ignore) {
                async.complete();
            }
        });
    }

    @Test
    public void testRunStandalone(TestContext ctx) {
        Async async = ctx.async();
        OraclePool pool = this.createPool(new OracleConnectOptions(this.options), new PoolOptions());
        pool.query("SELECT id, randomnumber FROM WORLD").execute(ctx.asyncAssertSuccess(v -> async.complete()));
        async.await(4000L);
    }

    @Test
    public void testMaxWaitQueueSize(TestContext ctx) {
        Async async = ctx.async();
        OraclePool pool = this.createPool(this.options, new PoolOptions().setMaxSize(1).setMaxWaitQueueSize(0));
        pool.getConnection(ctx.asyncAssertSuccess(v -> pool.getConnection(ctx.asyncAssertFailure(err -> async.complete()))));
        async.await(4000000L);
    }

    @Test
    public void testConcurrentMultipleConnection(TestContext ctx) {
        OraclePool pool = this.createPool(new OracleConnectOptions(this.options).setCachePreparedStatements(true), 2);
        int numRequests = 2;
        Async async = ctx.async(numRequests);
        for (int i = 0; i < numRequests; ++i) {
            pool.preparedQuery("SELECT * FROM Fortune WHERE id=?").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(results -> {
                ctx.assertEquals((Object)1, (Object)results.size());
                Tuple row = (Tuple)results.iterator().next();
                ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                async.countDown();
            }));
        }
    }

    @Test
    public void testConnectionHook(TestContext ctx) {
        AtomicInteger hookCount = new AtomicInteger();
        Handler hook = f -> {
            ctx.assertEquals((Object)1, (Object)hookCount.incrementAndGet());
            vertx.setTimer(100L, id -> f.close());
        };
        OraclePool pool = this.createPool(this.options, new PoolOptions().setMaxSize(1)).connectHandler(hook);
        pool.getConnection(ctx.asyncAssertSuccess(conn -> {
            ctx.assertEquals((Object)1, (Object)hookCount.get());
            conn.query("SELECT id, randomnumber FROM WORLD").execute(ctx.asyncAssertSuccess(v2 -> conn.close(ctx.asyncAssertSuccess())));
        }));
    }

    @Test
    public void testDirectQueryFromDuplicatedContext(TestContext ctx) {
        OraclePool pool = this.createPool(this.options, new PoolOptions().setMaxSize(1));
        Async async = ctx.async();
        vertx.runOnContext(v1 -> {
            ContextInternal current = (ContextInternal)Vertx.currentContext();
            pool.query("SELECT 1 FROM DUAL").execute(ctx.asyncAssertSuccess(res1 -> {
                ctx.assertTrue(Vertx.currentContext() == current);
                ContextInternal duplicated = current.duplicate();
                duplicated.runOnContext(v2 -> pool.query("SELECT 1 FROM DUAL").execute(ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertTrue(Vertx.currentContext() == duplicated);
                    async.complete();
                })));
            }));
        });
    }

    @Test
    public void testQueryFromDuplicatedContext(TestContext ctx) {
        OraclePool pool = this.createPool(this.options, new PoolOptions().setMaxSize(1));
        Async async = ctx.async();
        vertx.runOnContext(v1 -> {
            ContextInternal current = (ContextInternal)Vertx.currentContext();
            pool.query("SELECT 1 FROM DUAL").execute(ctx.asyncAssertSuccess(res1 -> {
                ctx.assertTrue(Vertx.currentContext() == current);
                ContextInternal duplicated = current.duplicate();
                duplicated.runOnContext(v2 -> pool.getConnection(ctx.asyncAssertSuccess(conn -> {
                    ctx.assertTrue(Vertx.currentContext() == duplicated);
                    conn.query("SELECT 1 FROM DUAL").execute(ctx.asyncAssertSuccess(res2 -> {
                        ctx.assertTrue(Vertx.currentContext() == duplicated);
                        conn.close(ctx.asyncAssertSuccess(v -> {
                            ctx.assertTrue(Vertx.currentContext() == duplicated);
                            async.complete();
                        }));
                    }));
                })));
            }));
        });
    }
}

