/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.oracleclient.impl.OracleConnectionUriParser;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ValidOracleConnectionUriParsingTest {
    private final String connectionUri;
    private final JsonObject expected;

    @Parameterized.Parameters(name="{0}: {1}")
    public static Object[][] data() {
        Object[][] params = new Object[][]{{"uri with user and password and sid", "oracle:thin:scott/tiger@myhost:1521:orcl", new JsonObject().put("serviceId", (Object)"orcl").put("host", (Object)"myhost").put("port", (Object)1521).put("user", (Object)"scott").put("password", (Object)"tiger")}, {"uri with sid but without port", "oracle:thin:scott/tiger@myhost:orcl", new JsonObject().put("serviceId", (Object)"orcl").put("host", (Object)"myhost").put("user", (Object)"scott").put("password", (Object)"tiger")}, {"uri without user and password", "oracle:thin:@myhost:1521:orcl", new JsonObject().put("serviceId", (Object)"orcl").put("host", (Object)"myhost").put("port", (Object)1521)}, {"uri with tcp protocol", "oracle:thin:@tcp://myhost:1521:orcl", new JsonObject().put("serviceId", (Object)"orcl").put("host", (Object)"myhost").put("port", (Object)1521)}, {"uri with tcps protocol", "oracle:thin:@tcps://myhost:1521:orcl", new JsonObject().put("ssl", (Object)true).put("serviceId", (Object)"orcl").put("host", (Object)"myhost").put("port", (Object)1521)}, {"uri with one connection property", "oracle:thin:@myhost:1521:orcl?key=val", new JsonObject().put("properties", (Object)new JsonObject().put("key", (Object)"val")).put("serviceId", (Object)"orcl").put("host", (Object)"myhost").put("port", (Object)1521)}, {"uri with several connection properties", "oracle:thin:@myhost:1521:orcl?k1=v1&k2=v2&k3=v3", new JsonObject().put("properties", (Object)new JsonObject().put("k1", (Object)"v1").put("k2", (Object)"v2").put("k3", (Object)"v3")).put("serviceId", (Object)"orcl").put("host", (Object)"myhost").put("port", (Object)1521)}, {"uri with service name", "oracle:thin:@[::1]:1521/orcl", new JsonObject().put("serviceName", (Object)"orcl").put("host", (Object)"::1").put("port", (Object)1521)}, {"uri with service name and instance name", "oracle:thin:@[::1]:1521/orcl/xe", new JsonObject().put("serviceName", (Object)"orcl").put("instanceName", (Object)"xe").put("host", (Object)"::1").put("port", (Object)1521)}, {"uri with service name, server mode and instance name", "oracle:thin:@[::1]/orcl:shared/xe", new JsonObject().put("serviceName", (Object)"orcl").put("instanceName", (Object)"xe").put("host", (Object)"::1").put("serverMode", (Object)"shared")}, {"uri with service name and server mode", "oracle:thin:@[::1]/orcl:dedicated", new JsonObject().put("serviceName", (Object)"orcl").put("host", (Object)"::1").put("serverMode", (Object)"dedicated")}, {"uri with service name with prop", "oracle:thin:@[::1]:1521/orcl?key=val", new JsonObject().put("properties", (Object)new JsonObject().put("key", (Object)"val")).put("serviceName", (Object)"orcl").put("host", (Object)"::1").put("port", (Object)1521)}, {"uri with service name and instance name with prop", "oracle:thin:@[::1]:1521/orcl/xe?key=val", new JsonObject().put("properties", (Object)new JsonObject().put("key", (Object)"val")).put("serviceName", (Object)"orcl").put("instanceName", (Object)"xe").put("host", (Object)"::1").put("port", (Object)1521)}, {"uri with service name, server mode and instance name with prop", "oracle:thin:@[::1]/orcl:shared/xe?key=val", new JsonObject().put("properties", (Object)new JsonObject().put("key", (Object)"val")).put("serviceName", (Object)"orcl").put("instanceName", (Object)"xe").put("host", (Object)"::1").put("serverMode", (Object)"shared")}, {"uri with service name and server mode with prop", "oracle:thin:@[::1]/orcl:dedicated?key=val", new JsonObject().put("properties", (Object)new JsonObject().put("key", (Object)"val")).put("serviceName", (Object)"orcl").put("host", (Object)"::1").put("serverMode", (Object)"dedicated")}, {"uri with TNSNames alias and TNS ADMIN short prop", "oracle:thin:@prod_db?TNS_ADMIN=/work/tns", new JsonObject().put("tnsAlias", (Object)"prod_db").put("tnsAdmin", (Object)"/work/tns")}, {"uri with TNSNames alias", "oracle:thin:@prod_db", new JsonObject().put("tnsAlias", (Object)"prod_db")}, {"uri with TNSNames alias with prop", "oracle:thin:@prod_db?key=val", new JsonObject().put("properties", (Object)new JsonObject().put("key", (Object)"val")).put("tnsAlias", (Object)"prod_db")}};
        return params;
    }

    public ValidOracleConnectionUriParsingTest(String name, String connectionUri, JsonObject expected) {
        this.connectionUri = connectionUri;
        this.expected = expected;
    }

    @Test
    public void shouldParseValidUri() {
        Assert.assertEquals((Object)this.expected, (Object)OracleConnectionUriParser.parse((String)this.connectionUri));
    }
}

