/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.spi;

import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.oracleclient.impl.OracleConnectionFactory;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.List;

public class OracleDriver
implements Driver {
    public Pool createPool(Vertx vertx, List<? extends SqlConnectOptions> databases, PoolOptions options) {
        if (vertx == null) {
            return OraclePool.pool(OracleDriver.wrap(databases.get(0)), options);
        }
        return OraclePool.pool(vertx, OracleDriver.wrap(databases.get(0)), options);
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        OracleConnectOptions options = OracleDriver.wrap(database);
        VertxInternal vi = (VertxInternal)vertx;
        VertxMetrics vertxMetrics = vi.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(database.getSocketAddress(), "sql", database.getMetricsName()) : null;
        QueryTracer tracer = new QueryTracer(vi.tracer(), database);
        return new OracleConnectionFactory(vi, options, new PoolOptions(), tracer, metrics);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof OracleConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    private static OracleConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof OracleConnectOptions) {
            return (OracleConnectOptions)options;
        }
        return new OracleConnectOptions(options);
    }
}

