/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Row;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class SimpleQueryCommand<C, R>
extends QueryCommand<C, R> {
    private final String sql;

    public SimpleQueryCommand(OracleConnectOptions options, String sql, Collector<Row, C, R> collector) {
        super(options, collector);
        this.sql = sql;
    }

    private Future<Boolean> execute(OraclePreparedStatement sqlStatement, ContextInternal context) {
        try {
            return Helper.first(sqlStatement.executeAsyncOracle(), context);
        }
        catch (SQLException throwables) {
            return context.failedFuture((Throwable)throwables);
        }
    }

    private void closeQuietly(OraclePreparedStatement c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Future<OracleResponse<R>> execute(OracleConnection conn, ContextInternal context) {
        OraclePreparedStatement ps = null;
        try {
            ps = (OraclePreparedStatement)conn.prepareStatement(this.sql);
            this.applyStatementOptions((Statement)ps);
            OraclePreparedStatement ref = ps;
            return this.execute(ps, context).compose(mayBeResult -> {
                try {
                    Future future = context.succeededFuture(this.decode((Statement)ref, (boolean)mayBeResult, false));
                    return future;
                }
                catch (SQLException throwables) {
                    Future future = context.failedFuture((Throwable)throwables);
                    return future;
                }
                finally {
                    this.closeQuietly(ref);
                }
            });
        }
        catch (SQLException e) {
            this.closeQuietly(ps);
            return context.failedFuture((Throwable)e);
        }
    }
}

