/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleRow;
import io.vertx.oracleclient.impl.commands.AbstractCommand;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class QueryCommand<C, R>
extends AbstractCommand<OracleResponse<R>> {
    private final Collector<Row, C, R> collector;
    private final OracleConnectOptions options;

    public QueryCommand(OracleConnectOptions options, Collector<Row, C, R> collector) {
        this.options = options;
        this.collector = collector;
    }

    protected OracleResponse<R> decode(Statement statement, boolean returnedResultSet, boolean returnedKeys) throws SQLException {
        OracleResponse<R> response = new OracleResponse<R>(statement.getUpdateCount());
        if (returnedResultSet) {
            while (returnedResultSet) {
                try (ResultSet rs = statement.getResultSet();){
                    this.decodeResultSet(rs, response);
                }
                if (returnedKeys) {
                    this.decodeReturnedKeys(statement, response);
                }
                returnedResultSet = statement.getMoreResults();
            }
        } else {
            this.collector.accumulator();
            C container = this.collector.supplier().get();
            response.empty(this.collector.finisher().apply(container));
            if (returnedKeys) {
                this.decodeReturnedKeys(statement, response);
            }
        }
        return response;
    }

    protected OracleResponse<R> decode(Statement statement, int[] returnedBatchResult, boolean returnedKeys) throws SQLException {
        OracleResponse<R> response = new OracleResponse<R>(returnedBatchResult.length);
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        RowDesc desc = new RowDesc(Collections.emptyList());
        C container = this.collector.supplier().get();
        for (int result : returnedBatchResult) {
            OracleRow row = new OracleRow(desc);
            row.addValue(result);
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, returnedBatchResult.length);
        if (returnedKeys) {
            this.decodeReturnedKeys(statement, response);
        }
        return response;
    }

    private void decodeResultSet(ResultSet rs, OracleResponse<R> response) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        int size = 0;
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            ++size;
            OracleRow row = new OracleRow(desc);
            for (int i = 1; i <= cols; ++i) {
                Object res = QueryCommand.convertSqlValue(rs.getObject(i));
                row.addValue(res);
            }
            accumulator.accept(container, row);
        }
        response.push(this.collector.finisher().apply(container), desc, size);
    }

    private R decodeRawResultSet(ResultSet rs) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        ArrayList<String> columnNames = new ArrayList<String>();
        RowDesc desc = new RowDesc(columnNames);
        C container = this.collector.supplier().get();
        ResultSetMetaData metaData = rs.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
        }
        while (rs.next()) {
            OracleRow row = new OracleRow(desc);
            for (int i = 1; i <= cols; ++i) {
                Object res = QueryCommand.convertSqlValue(rs.getObject(i));
                row.addValue(res);
            }
            accumulator.accept(container, row);
        }
        return this.collector.finisher().apply(container);
    }

    private void decodeReturnedKeys(Statement statement, OracleResponse<R> response) throws SQLException {
        int cols;
        ResultSetMetaData metaData;
        OracleRow keys = null;
        ResultSet keysRS = statement.getGeneratedKeys();
        if (keysRS != null && (metaData = keysRS.getMetaData()) != null && (cols = metaData.getColumnCount()) > 0) {
            int i;
            ArrayList<String> keysColumnNames = new ArrayList<String>();
            RowDesc keysDesc = new RowDesc(keysColumnNames);
            for (i = 1; i <= cols; ++i) {
                keysColumnNames.add(metaData.getColumnLabel(i));
            }
            if (keysRS.next()) {
                keys = new OracleRow(keysDesc);
                for (i = 1; i <= cols; ++i) {
                    Object res = QueryCommand.convertSqlValue(keysRS.getObject(i));
                    keys.addValue(res);
                }
            }
            response.returnedKeys(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertSqlValue(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof byte[]) {
            return value;
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                BigDecimal d = (BigDecimal)value;
                if (d.scale() == 0) {
                    return ((BigDecimal)value).toBigInteger();
                }
                return ((BigDecimal)value).doubleValue();
            }
            return value;
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toInstant().atOffset(ZoneOffset.UTC);
        }
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            try {
                String string = c.getSubString(1L, (int)c.length());
                return string;
            }
            finally {
                try {
                    c.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            try {
                byte[] byArray = b.getBytes(1L, (int)b.length());
                return byArray;
            }
            finally {
                try {
                    b.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array a = (java.sql.Array)value;
            try {
                Object arr = a.getArray();
                if (arr != null) {
                    int len = Array.getLength(arr);
                    Object[] castedArray = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        castedArray[i] = QueryCommand.convertSqlValue(Array.get(arr, i));
                    }
                    Object[] objectArray = castedArray;
                    return objectArray;
                }
            }
            finally {
                a.free();
            }
        }
        if (value instanceof RowId) {
            return ((RowId)value).getBytes();
        }
        if (value instanceof Struct) {
            return Tuple.of((Object)((Struct)value).getAttributes());
        }
        return value.toString();
    }

    boolean returnAutoGeneratedKeys(Connection conn, OraclePrepareOptions options) {
        boolean autoGeneratedKeys = options == null || options.isAutoGeneratedKeys();
        boolean autoGeneratedIndexes = options != null && options.getAutoGeneratedKeysIndexes() != null && options.getAutoGeneratedKeysIndexes().size() > 0;
        return false;
    }

    protected Future<PreparedStatement> prepare(ExtendedQueryCommand<R> query, Connection conn, boolean returnAutoGeneratedKeys, Context context) {
        OraclePrepareOptions options = query.options() instanceof OraclePrepareOptions ? (OraclePrepareOptions)query.options() : null;
        boolean autoGeneratedIndexes = options != null && options.getAutoGeneratedKeysIndexes() != null && options.getAutoGeneratedKeysIndexes().size() > 0;
        String sql = query.sql();
        int fetch = query.fetch();
        if (returnAutoGeneratedKeys && !autoGeneratedIndexes) {
            return Helper.completeOrFail(() -> {
                PreparedStatement statement = conn.prepareStatement(sql, 1);
                this.configureFetch(fetch, statement);
                if (query.cursorId() != null) {
                    statement.setCursorName(query.cursorId());
                }
                return statement;
            });
        }
        if (autoGeneratedIndexes) {
            return context.executeBlocking(promise -> this.createPreparedStatement(conn, sql, options, fetch, (Promise<PreparedStatement>)promise));
        }
        return Helper.completeOrFail(() -> {
            PreparedStatement statement = conn.prepareStatement(sql);
            this.configureFetch(fetch, statement);
            return statement;
        });
    }

    private void configureFetch(int fetch, PreparedStatement statement) throws SQLException {
        if (fetch > 0) {
            statement.setFetchSize(fetch);
        }
    }

    protected void createPreparedStatement(Connection conn, String sql, OraclePrepareOptions options, int fetch, Promise<PreparedStatement> promise) {
        JsonArray indexes = options.getAutoGeneratedKeysIndexes();
        try {
            if (indexes.getValue(0) instanceof Number) {
                int[] keys = new int[indexes.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = indexes.getInteger(i);
                }
                promise.complete((Object)conn.prepareStatement(sql, keys));
            } else if (indexes.getValue(0) instanceof String) {
                String[] keys = new String[indexes.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = indexes.getString(i);
                }
                PreparedStatement statement = conn.prepareStatement(sql, keys);
                this.configureFetch(fetch, statement);
                promise.complete((Object)statement);
            } else {
                promise.fail((Throwable)new SQLException("Invalid type of index, only [int, String] allowed"));
            }
        }
        catch (SQLException e) {
            promise.fail((Throwable)e);
        }
        catch (RuntimeException e) {
            promise.fail((Throwable)new SQLException(e));
        }
    }
}

