/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.commands.AbstractCommand;
import io.vertx.oracleclient.impl.commands.OraclePreparedStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;

public class PrepareStatementCommand
extends AbstractCommand<io.vertx.sqlclient.impl.PreparedStatement> {
    private final OraclePrepareOptions options;
    private final String sql;

    public PrepareStatementCommand(OraclePrepareOptions options, String sql) {
        this.options = options;
        this.sql = sql;
    }

    @Override
    public Future<io.vertx.sqlclient.impl.PreparedStatement> execute(OracleConnection conn, ContextInternal context) {
        boolean autoGeneratedIndexes;
        boolean autoGeneratedKeys = this.options == null || this.options.isAutoGeneratedKeys();
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null;
        if (autoGeneratedKeys && !autoGeneratedIndexes) {
            return this.prepareReturningKey(conn, context);
        }
        if (autoGeneratedIndexes) {
            return this.prepareWithAutoGeneratedIndexes(conn, (Context)context);
        }
        return this.prepare(conn, (Context)context);
    }

    private Future<io.vertx.sqlclient.impl.PreparedStatement> prepareWithAutoGeneratedIndexes(OracleConnection conn, Context context) {
        return context.owner().executeBlocking(p -> {
            JsonArray indexes = this.options.getAutoGeneratedKeysIndexes();
            try {
                if (indexes.getValue(0) instanceof Number) {
                    int[] keys = new int[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getInteger(i);
                    }
                    OraclePreparedStatement statement = this.create(conn.prepareStatement(this.sql, keys));
                    p.complete((Object)statement);
                } else if (indexes.getValue(0) instanceof String) {
                    String[] keys = new String[indexes.size()];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = indexes.getString(i);
                    }
                    OraclePreparedStatement statement = this.create(conn.prepareStatement(this.sql, keys));
                    p.complete((Object)statement);
                } else {
                    p.fail((Throwable)new SQLException("Invalid type of index, only [int, String] allowed"));
                }
            }
            catch (RuntimeException | SQLException e) {
                p.fail((Throwable)e);
            }
        });
    }

    private Future<io.vertx.sqlclient.impl.PreparedStatement> prepareReturningKey(OracleConnection connection, ContextInternal context) {
        try {
            PreparedStatement ps = connection.prepareStatement(this.sql, 1);
            this.applyStatementOptions(ps);
            return context.succeededFuture((Object)new OraclePreparedStatement(this.sql, ps));
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
    }

    private Future<io.vertx.sqlclient.impl.PreparedStatement> prepare(OracleConnection connection, Context context) {
        return context.owner().executeBlocking(p -> {
            try {
                OraclePreparedStatement result = this.create(connection.prepareStatement(this.sql));
                p.complete((Object)result);
            }
            catch (Exception e) {
                p.fail((Throwable)e);
            }
        });
    }

    private OraclePreparedStatement create(PreparedStatement statement) throws SQLException {
        this.applyStatementOptions(statement);
        return new OraclePreparedStatement(this.sql, statement);
    }
}

