/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class OraclePreparedQuery<C, R>
extends QueryCommand<C, R> {
    private final ExtendedQueryCommand<R> query;
    private final Tuple params;

    public OraclePreparedQuery(OracleConnectOptions options, ExtendedQueryCommand<R> query, Collector<Row, C, R> collector, Tuple params) {
        super(options, collector);
        this.query = query;
        this.params = params;
    }

    @Override
    public Future<OracleResponse<R>> execute(OracleConnection conn, ContextInternal context) {
        boolean returnAutoGeneratedKeys = this.returnAutoGeneratedKeys((Connection)conn, this.query.options() instanceof OraclePrepareOptions ? (OraclePrepareOptions)this.query.options() : null);
        Future<PreparedStatement> future = this.prepare((Context)context, (Connection)conn, returnAutoGeneratedKeys);
        return future.flatMap(ps -> {
            try {
                this.fillStatement((PreparedStatement)ps, (Connection)conn);
            }
            catch (SQLException throwables) {
                Helper.closeQuietly(ps);
                return context.failedFuture((Throwable)throwables);
            }
            return this.execute((PreparedStatement)ps, context).map(res -> Helper.getOrHandleSQLException(() -> this.decode((Statement)ps, (boolean)res, returnAutoGeneratedKeys))).onComplete(ar -> Helper.closeQuietly(ps));
        });
    }

    public Future<Boolean> execute(PreparedStatement sqlStatement, ContextInternal context) {
        OraclePreparedStatement oraclePreparedStatement = Helper.unwrapOraclePreparedStatement(sqlStatement);
        try {
            return Helper.first(oraclePreparedStatement.executeAsyncOracle(), context);
        }
        catch (SQLException throwables) {
            return context.failedFuture((Throwable)throwables);
        }
    }

    private Future<PreparedStatement> prepare(Context context, Connection conn, boolean returnAutoGeneratedKeys) {
        return this.prepare(this.query, conn, returnAutoGeneratedKeys, context);
    }

    private void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Object value = this.adaptType(conn, this.params.getValue(i));
            ps.setObject(i + 1, value);
        }
    }

    private Object adaptType(Connection conn, Object value) throws SQLException {
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return Time.valueOf(time);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return Date.valueOf(date);
        }
        if (value instanceof Instant) {
            Instant timestamp = (Instant)value;
            return Timestamp.from(timestamp);
        }
        if (value instanceof Buffer) {
            Buffer buffer = (Buffer)value;
            Blob blob = conn.createBlob();
            blob.setBytes(1L, buffer.getBytes());
            return blob;
        }
        return value;
    }
}

