/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class OraclePreparedBatch<C, R>
extends QueryCommand<C, R> {
    private final ExtendedQueryCommand<R> query;
    private final List<Tuple> listParams;

    public OraclePreparedBatch(OracleConnectOptions options, ExtendedQueryCommand<R> query, Collector<Row, C, R> collector, List<Tuple> listParams) {
        super(options, collector);
        this.query = query;
        this.listParams = listParams;
    }

    @Override
    public Future<OracleResponse<R>> execute(OracleConnection conn, ContextInternal context) {
        boolean returnAutoGeneratedKeys = this.returnAutoGeneratedKeys((Connection)conn, this.query.options() instanceof OraclePrepareOptions ? (OraclePrepareOptions)this.query.options() : null);
        return this.prepare(this.query, (Connection)conn, returnAutoGeneratedKeys, (Context)context).flatMap(ps -> {
            try {
                for (Tuple params : this.listParams) {
                    this.fillStatement((PreparedStatement)ps, (Connection)conn, params);
                    ps.addBatch();
                }
            }
            catch (SQLException e) {
                Helper.closeQuietly(ps);
                return context.failedFuture((Throwable)e);
            }
            return this.executeBatch((PreparedStatement)ps, context).map(res -> Helper.getOrHandleSQLException(() -> this.decode((Statement)ps, (int[])res, returnAutoGeneratedKeys))).onComplete(ar -> Helper.closeQuietly(ps));
        });
    }

    public Future<int[]> executeBatch(PreparedStatement batchUpdateStatement, ContextInternal context) {
        OraclePreparedStatement oraclePreparedStatement = Helper.unwrapOraclePreparedStatement(batchUpdateStatement);
        try {
            return Helper.collect(oraclePreparedStatement.executeBatchAsyncOracle(), context).map(list -> {
                int[] res = new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = ((Long)list.get(i)).intValue();
                }
                return res;
            });
        }
        catch (SQLException throwables) {
            return context.failedFuture((Throwable)throwables);
        }
    }

    private void fillStatement(PreparedStatement ps, Connection conn, Tuple params) throws SQLException {
        for (int i = 0; i < params.size(); ++i) {
            Object value = this.adaptType(conn, params.getValue(i));
            ps.setObject(i + 1, value);
        }
    }

    private Object adaptType(Connection conn, Object value) throws SQLException {
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return Time.valueOf(time);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return Date.valueOf(date);
        }
        if (value instanceof Instant) {
            Instant timestamp = (Instant)value;
            return Timestamp.from(timestamp);
        }
        if (value instanceof Buffer) {
            Buffer blob = (Buffer)value;
            return conn.createBlob().setBytes(0L, blob.getBytes());
        }
        return value;
    }
}

