/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleColumnDesc;
import io.vertx.oracleclient.impl.OracleRow;
import io.vertx.oracleclient.impl.RowReader;
import io.vertx.oracleclient.impl.commands.OraclePreparedQuery;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Flow;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class OracleCursorQueryCommand<C, R>
extends QueryCommand<C, R> {
    private final ExtendedQueryCommand<R> command;
    private final Tuple params;

    public OracleCursorQueryCommand(OracleConnectOptions options, ExtendedQueryCommand<R> command, Tuple params) {
        super(options, null);
        this.command = command;
        this.params = params;
    }

    @Override
    public Future<OracleResponse<R>> execute(OracleConnection conn, ContextInternal context) {
        Future<PreparedStatement> future = this.prepare(this.command, (Connection)conn, false, (Context)context);
        return future.flatMap(ps -> {
            try {
                this.fillStatement((PreparedStatement)ps, (Connection)conn);
            }
            catch (SQLException throwables) {
                Helper.closeQuietly(ps);
                return context.failedFuture((Throwable)throwables);
            }
            return this.createRowReader((PreparedStatement)ps, context).compose(rr -> rr.read(this.command.fetch())).map(x -> null).onComplete(ar -> Helper.closeQuietly(ps));
        });
    }

    public Future<RowReader<R, ?>> createRowReader(PreparedStatement sqlStatement, ContextInternal context) {
        OraclePreparedStatement oraclePreparedStatement = Helper.unwrapOraclePreparedStatement(sqlStatement);
        try {
            Flow.Publisher publisher = oraclePreparedStatement.executeQueryAsyncOracle();
            return Helper.first(publisher, context).compose(ors -> {
                try {
                    RowDesc description = OracleColumnDesc.rowDesc(ors.getMetaData());
                    ArrayList<String> types = new ArrayList<String>();
                    for (int i = 1; i <= ors.getMetaData().getColumnCount(); ++i) {
                        types.add(ors.getMetaData().getColumnClassName(i));
                    }
                    return RowReader.create(ors.publisherOracle(or -> Helper.getOrHandleSQLException(() -> OracleCursorQueryCommand.transform(types, description, or))), this.command.collector(), context, this.command.resultHandler(), description);
                }
                catch (SQLException e) {
                    return context.failedFuture((Throwable)e);
                }
            });
        }
        catch (SQLException throwables) {
            return context.failedFuture((Throwable)throwables);
        }
    }

    private static Row transform(List<String> ors, RowDesc desc, oracle.jdbc.OracleRow or) throws SQLException {
        OracleRow row = new OracleRow(desc);
        for (int i = 1; i <= desc.columnNames().size(); ++i) {
            Object res = QueryCommand.convertSqlValue(or.getObject(i, OracleCursorQueryCommand.getType(ors.get(i - 1))));
            row.addValue(res);
        }
        return row;
    }

    private static Class<?> getType(String cn) {
        try {
            return OraclePreparedQuery.class.getClassLoader().loadClass(cn);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Object value = this.adaptType(conn, this.params.getValue(i));
            ps.setObject(i + 1, value);
        }
    }

    private Object adaptType(Connection conn, Object value) throws SQLException {
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return Time.valueOf(time);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return Date.valueOf(date);
        }
        if (value instanceof Instant) {
            Instant timestamp = (Instant)value;
            return Timestamp.from(timestamp);
        }
        if (value instanceof Buffer) {
            Buffer buffer = (Buffer)value;
            Blob blob = conn.createBlob();
            blob.setBytes(1L, buffer.getBytes());
            return blob;
        }
        return value;
    }
}

