/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;

public class RowReader<R, A>
implements Flow.Subscriber<Row> {
    private final Flow.Publisher<Row> publisher;
    private final ContextInternal context;
    private final RowDesc description;
    private final QueryResultHandler<R> handler;
    private volatile Flow.Subscription subscription;
    private final Promise<Void> subscriptionPromise;
    private Promise<Void> readPromise;
    private volatile boolean completed;
    private volatile Throwable failed;
    private final Collector<Row, A, R> collector;
    private A accumulator;
    private int count;
    private final AtomicInteger toRead = new AtomicInteger();
    private final AtomicBoolean wip = new AtomicBoolean();

    public RowReader(Flow.Publisher<Row> publisher, Collector<Row, A, R> collector, RowDesc description, Promise<Void> promise, QueryResultHandler<R> handler, ContextInternal context) {
        this.publisher = publisher;
        this.description = description;
        this.subscriptionPromise = promise;
        this.handler = handler;
        this.context = context;
        this.collector = collector;
    }

    public static <R> Future<RowReader<R, ?>> create(Flow.Publisher<Row> publisher, Collector<Row, ?, R> collector, ContextInternal context, QueryResultHandler<R> handler, RowDesc description) {
        PromiseInternal promise = context.promise();
        RowReader reader = new RowReader(publisher, collector, description, (Promise<Void>)promise, handler, context);
        reader.subscribe();
        return promise.future().map(reader);
    }

    public Future<Void> read(int fetchSize) {
        if (this.subscription == null) {
            return this.context.failedFuture((Throwable)new IllegalStateException("Not subscribed"));
        }
        if (this.completed) {
            return this.context.succeededFuture();
        }
        if (this.failed != null) {
            return this.context.failedFuture(this.failed);
        }
        if (this.wip.compareAndSet(false, true)) {
            this.toRead.set(fetchSize);
            this.accumulator = this.collector.supplier().get();
            this.count = 0;
            this.readPromise = this.context.promise();
            this.subscription.request(fetchSize);
            return this.readPromise.future();
        }
        return this.context.failedFuture((Throwable)new IllegalStateException("Read already in progress"));
    }

    private void subscribe() {
        this.publisher.subscribe(this);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        this.context.runOnContext(x -> this.subscriptionPromise.complete(null));
    }

    @Override
    public void onNext(Row item) {
        this.collector.accumulator().accept(this.accumulator, item);
        ++this.count;
        if (this.toRead.decrementAndGet() == 0 && this.wip.compareAndSet(true, false)) {
            R result = this.collector.finisher().apply(this.accumulator);
            try {
                this.handler.handleResult(this.count, this.count, this.description, result, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.readPromise.complete();
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.wip.compareAndSet(true, false)) {
            this.failed = throwable;
            this.handler.handleResult(0, 0, this.description, null, throwable);
        }
    }

    @Override
    public void onComplete() {
        if (this.wip.compareAndSet(true, false)) {
            this.completed = true;
            this.context.runOnContext(x -> this.readPromise.complete(null));
        }
    }
}

