/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.oracleclient.impl.OracleConnectionFactory;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.function.Function;

public class OraclePoolImpl
extends SqlClientBase<OraclePoolImpl>
implements OraclePool {
    private final OracleConnectionFactory factory;
    private final VertxInternal vertx;
    private Closeable onClose;

    public static OraclePoolImpl create(VertxInternal vertx, boolean closeVertx, OracleConnectOptions connectOptions, PoolOptions poolOptions, QueryTracer tracer) {
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        OracleConnectionFactory factory = new OracleConnectionFactory(vertx, connectOptions, poolOptions, tracer, metrics);
        OraclePoolImpl pool = new OraclePoolImpl(vertx, factory, metrics, tracer);
        if (closeVertx) {
            pool.onClose(completion -> vertx.close());
        } else {
            ContextInternal ctx = vertx.getContext();
            if (ctx != null) {
                ctx.addCloseHook(completion -> pool.close().onComplete((Handler)completion));
            } else {
                vertx.addCloseHook(completion -> pool.close().onComplete((Handler)completion));
            }
        }
        return pool;
    }

    public OraclePoolImpl(VertxInternal vertx, OracleConnectionFactory factory, ClientMetrics metrics, QueryTracer tracer) {
        super(tracer, metrics);
        this.factory = factory;
        this.vertx = vertx;
    }

    private void onClose(Closeable closeable) {
        this.onClose = closeable;
    }

    protected ContextInternal context() {
        return this.vertx.getOrCreateContext();
    }

    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        this.getConnection().onComplete(handler);
    }

    public Future<SqlConnection> getConnection() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return this.getConnectionInternal(ctx);
    }

    private Future<SqlConnection> getConnectionInternal(ContextInternal ctx) {
        return this.factory.connect(ctx).map(c -> {
            SqlConnectionImpl connection = new SqlConnectionImpl(ctx, (ConnectionFactory)this.factory, c, this.tracer, this.metrics);
            c.init((Connection.Holder)connection);
            return connection;
        });
    }

    public Pool connectHandler(Handler<SqlConnection> handler) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Pool connectionProvider(Function<Context, Future<SqlConnection>> provider) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int size() {
        return 0;
    }

    protected <T> PromiseInternal<T> promise() {
        return this.vertx.promise();
    }

    protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        return this.vertx.promise(handler);
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        Promise promise = Promise.promise();
        this.factory.close((Promise<Void>)promise);
        promise.future().onComplete(handler).compose(x -> {
            Promise p = Promise.promise();
            if (this.onClose != null) {
                this.onClose.close(p);
            } else {
                p.complete();
            }
            return p.future();
        });
    }

    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.factory.close((Promise<Void>)promise);
        return promise.future().compose(x -> {
            Promise p = Promise.promise();
            if (this.onClose != null) {
                this.onClose.close(p);
            } else {
                p.complete();
            }
            return p.future();
        });
    }

    public <R> Future<R> schedule(ContextInternal contextInternal, CommandBase<R> commandBase) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return this.getConnectionInternal(ctx).flatMap(conn -> ((SqlConnectionImpl)conn).schedule(ctx, commandBase).eventually(r -> conn.close()));
    }
}

