/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.CommandHandler;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleDatabaseHelper;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleConnectionFactory
implements ConnectionFactory {
    private final OracleConnectOptions options;
    private final OracleDataSource datasource;
    private final PoolOptions poolOptions;
    private final VertxInternal vertx;
    private final QueryTracer tracer;
    private final ClientMetrics metrics;

    public OracleConnectionFactory(VertxInternal vertx, OracleConnectOptions options, PoolOptions poolOptions, QueryTracer tracer, ClientMetrics metrics) {
        this.vertx = vertx;
        this.options = options;
        this.poolOptions = poolOptions;
        this.datasource = OracleDatabaseHelper.createDataSource(options);
        this.tracer = tracer;
        this.metrics = metrics;
    }

    public OracleConnectOptions options() {
        return this.options;
    }

    public Future<Connection> connect(ContextInternal context) {
        CompletionStage stage = Helper.getOrHandleSQLException(() -> this.datasource.createConnectionBuilder().buildAsyncOracle());
        return Helper.contextualize(stage, context).map(c -> new CommandHandler(context, this.options, (OracleConnection)c));
    }

    public void close(Promise<Void> promise) {
        promise.complete();
    }

    public Future<SqlConnection> connect(Context context) {
        ContextInternal ic = (ContextInternal)context;
        return this.connect(ic).map(c -> {
            SqlConnectionImpl connection = new SqlConnectionImpl(ic, (ConnectionFactory)this, c, this.tracer, this.metrics);
            c.init((Connection.Holder)connection);
            return connection;
        });
    }
}

