/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.impl.RowDesc;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class OracleColumnDesc
implements ColumnDescriptor {
    private final String name;
    private final String typeName;
    private final JDBCType type;

    public static RowDesc rowDesc(ResultSetMetaData metaData) throws SQLException {
        int cols = metaData.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(cols);
        ArrayList<OracleColumnDesc> columnDescriptors = new ArrayList<OracleColumnDesc>(cols);
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
            columnDescriptors.add(new OracleColumnDesc(metaData, i));
        }
        return new RowDesc(columnNames, columnDescriptors);
    }

    public OracleColumnDesc(ResultSetMetaData md, int idx) throws SQLException {
        this.name = md.getColumnLabel(idx);
        this.typeName = md.getColumnTypeName(idx);
        this.type = JDBCType.valueOf(md.getColumnType(idx));
    }

    public String name() {
        return this.name;
    }

    public boolean isArray() {
        return false;
    }

    public String typeName() {
        return this.typeName;
    }

    public JDBCType jdbcType() {
        return this.type;
    }
}

