/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import oracle.jdbc.OraclePreparedStatement;

public class Helper {
    public static <T> Future<T> completeOrFail(ThrowingSupplier<T> supplier) {
        try {
            return Future.succeededFuture(supplier.getOrThrow());
        }
        catch (SQLException throwables) {
            return Future.failedFuture((Throwable)throwables);
        }
    }

    public static void closeQuietly(Statement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static <T> Future<T> contextualize(CompletionStage<T> stage, ContextInternal context) {
        PromiseInternal future = context.promise();
        stage.whenComplete((arg_0, arg_1) -> Helper.lambda$contextualize$0((Promise)future, arg_0, arg_1));
        return future.future();
    }

    public static OraclePreparedStatement unwrapOraclePreparedStatement(PreparedStatement preparedStatement) {
        return Helper.getOrHandleSQLException(() -> preparedStatement.unwrap(OraclePreparedStatement.class));
    }

    public static <T> T getOrHandleSQLException(ThrowingSupplier<T> supplier) throws VertxException {
        try {
            return supplier.getOrThrow();
        }
        catch (SQLException sqlException) {
            throw new VertxException((Throwable)sqlException);
        }
    }

    public static void runOrHandleSQLException(ThrowingRunnable runnable) throws VertxException {
        try {
            runnable.runOrThrow();
        }
        catch (SQLException sqlException) {
            throw new VertxException((Throwable)sqlException);
        }
    }

    public static <T> Future<T> first(Flow.Publisher<T> publisher, final ContextInternal context) {
        PromiseInternal promise = context.promise();
        publisher.subscribe(new Flow.Subscriber<T>((Promise)promise){
            volatile Flow.Subscription subscription;
            final /* synthetic */ Promise val$promise;
            {
                this.val$promise = promise;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(T item) {
                context.runOnContext(x -> this.val$promise.tryComplete(item));
                this.subscription.cancel();
            }

            @Override
            public void onError(Throwable throwable) {
                this.val$promise.fail(throwable);
            }

            @Override
            public void onComplete() {
                this.val$promise.tryComplete(null);
            }
        });
        return promise.future();
    }

    public static <T> Future<List<T>> collect(Flow.Publisher<T> publisher, final ContextInternal context) {
        PromiseInternal promise = context.promise();
        publisher.subscribe(new Flow.Subscriber<T>((Promise)promise){
            final List<T> list = new ArrayList();
            final /* synthetic */ Promise val$promise;
            {
                this.val$promise = promise;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T item) {
                this.list.add(item);
            }

            @Override
            public void onError(Throwable throwable) {
                context.runOnContext(x -> this.val$promise.fail(throwable));
            }

            @Override
            public void onComplete() {
                this.val$promise.complete(this.list);
            }
        });
        return promise.future();
    }

    private static /* synthetic */ void lambda$contextualize$0(Promise future, Object r, Throwable f) {
        if (f != null) {
            future.fail(f);
        } else {
            future.complete(r);
        }
    }

    static interface JdbcRow {
        public <T> T getObject(int var1, Class<T> var2);

        public JdbcRow copy();
    }

    @FunctionalInterface
    public static interface ThrowingRunnable
    extends Runnable {
        public void runOrThrow() throws SQLException;

        @Override
        default public void run() throws VertxException {
            Helper.runOrHandleSQLException(this);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T>
    extends Supplier<T> {
        public T getOrThrow() throws SQLException;

        @Override
        default public T get() throws VertxException {
            return Helper.getOrHandleSQLException(this);
        }
    }
}

