/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.oracleclient.test.tck.ClientConfig;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.tck.SimpleQueryTestBase;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OracleSimpleQueryTest
extends SimpleQueryTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    public void cleanTestTable(TestContext ctx) {
        this.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("TRUNCATE TABLE mutable").execute(result -> conn.close())));
    }

    @Test
    public void testInsert(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO mutable (id, val) VALUES (1, 'Whatever')").execute(ctx.asyncAssertSuccess(r1 -> {
            ctx.assertEquals((Object)1, (Object)r1.rowCount());
            async.complete();
        }))));
        async.await();
    }
}

