/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.core.Future;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.oracleclient.test.tck.ClientConfig;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.PreparedBatchTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OraclePreparedBatchTest
extends PreparedBatchTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    protected void initConnector() {
        this.connector = ClientConfig.POOLED.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    protected String statement(String ... parts) {
        return String.join((CharSequence)" ?", parts);
    }

    public void cleanTestTable(TestContext ctx) {
        this.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("TRUNCATE TABLE mutable").execute(result -> conn.close())));
    }

    @Test
    public void testInsert(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect(ctx.asyncAssertSuccess(conn -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)79991, (Object)"batch one"));
            batch.add(Tuple.of((Object)79992, (Object)"batch two"));
            batch.add(Tuple.wrap(Arrays.asList(79993, "batch three")));
            batch.add(Tuple.wrap(Arrays.asList(79994, "batch four")));
            Future fut = conn.preparedQuery("INSERT INTO MUTABLE (id, val) VALUES (?, ?)").executeBatch(batch);
            fut.onComplete(result -> {
                ctx.assertFalse(result.failed());
                ctx.assertEquals((Object)4, (Object)((RowSet)result.result()).rowCount());
                conn.preparedQuery("SELECT * FROM mutable WHERE id=?").execute(Tuple.of((Object)79991), ctx.asyncAssertSuccess(rows1 -> {
                    this.verify((RowSet<Row>)rows1, ctx, 79991, "batch one");
                    conn.preparedQuery("SELECT * FROM mutable WHERE id=?").execute(Tuple.of((Object)79992), ctx.asyncAssertSuccess(ar2 -> {
                        this.verify((RowSet<Row>)ar2, ctx, 79992, "batch two");
                        conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", "")).execute(Tuple.of((Object)79993), ctx.asyncAssertSuccess(ar3 -> {
                            this.verify((RowSet<Row>)ar3, ctx, 79993, "batch three");
                            conn.preparedQuery(this.statement("SELECT * FROM mutable WHERE id=", "")).execute(Tuple.of((Object)79994), ctx.asyncAssertSuccess(ar4 -> {
                                this.verify((RowSet<Row>)ar4, ctx, 79994, "batch four");
                                async.complete();
                            }));
                        }));
                    }));
                }));
            });
        }));
    }

    private void verify(RowSet<Row> rows, TestContext ctx, int id, String val) {
        ctx.assertEquals((Object)1, (Object)rows.size());
        Row one = (Row)rows.iterator().next();
        ctx.assertEquals((Object)id, (Object)one.getInteger(0));
        ctx.assertEquals((Object)val, (Object)one.getString(1));
    }

    @Test
    @Ignore(value="Oracle does not support batching queries")
    public void testBatchQuery(TestContext ctx) {
    }

    @Test
    public void testEmptyBatch(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect(ctx.asyncAssertSuccess(conn -> {
            ArrayList batch = new ArrayList();
            conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", "")).executeBatch(batch, ctx.asyncAssertFailure(err -> async.complete()));
        }));
    }

    @Test
    public void testIncorrectNumBatchArguments(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect(ctx.asyncAssertSuccess(conn -> {
            ArrayList<Tuple> batch = new ArrayList<Tuple>();
            batch.add(Tuple.of((Object)1, (Object)2));
            conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", "")).executeBatch(batch, ctx.asyncAssertFailure(err -> async.complete()));
        }));
    }
}

