/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.oracleclient.test.tck.ClientConfig;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import io.vertx.sqlclient.tck.ConnectionTestBase;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OracleConnectionTest
extends ConnectionTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    public void setUp() throws Exception {
        super.setUp();
        this.options = rule.options();
        this.connector = ClientConfig.CONNECT.connect(this.vertx, this.options);
    }

    public void tearDown(TestContext ctx) {
        this.connector.close();
        super.tearDown(ctx);
    }

    @Test
    public void testConnect(TestContext ctx) {
        Async async = ctx.async();
        this.connect(ctx.asyncAssertSuccess(conn -> async.complete()));
    }

    @Test
    public void testConnectInvalidDatabase(TestContext ctx) {
        Async async = ctx.async();
        this.options.setDatabase("invalidDatabase");
        this.connect(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err.getMessage().contains("ORA-12514"));
            async.complete();
        }));
    }

    @Test
    public void testConnectInvalidPassword(TestContext ctx) {
        Async async = ctx.async();
        this.options.setPassword("invalidPassword");
        this.connect(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err.getMessage().contains("ORA-01017"));
            async.complete();
        }));
    }

    @Test
    public void testConnectInvalidUsername(TestContext ctx) {
        Async async = ctx.async();
        this.options.setUser("invalidUsername");
        this.connect(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err.getMessage().contains("ORA-01017"));
            async.complete();
        }));
    }

    @Test
    public void testClose(TestContext ctx) {
        Async closedAsync = ctx.async();
        Async closeAsync = ctx.async();
        this.connect(ctx.asyncAssertSuccess(conn -> {
            conn.closeHandler(v -> closedAsync.complete());
            conn.close(ctx.asyncAssertSuccess(v -> closeAsync.complete()));
        }));
        closedAsync.await();
    }

    @Test
    public void testCloseWithErrorInProgress(TestContext ctx) {
        Async async = ctx.async(2);
        this.connect(ctx.asyncAssertSuccess(conn -> {
            conn.query("SELECT whatever from DOES_NOT_EXIST").execute(ctx.asyncAssertFailure(err -> async.countDown()));
            conn.closeHandler(v -> async.countDown());
            conn.close();
        }));
        async.await();
    }

    @Test
    public void testCloseWithQueryInProgress(TestContext ctx) {
        Async async = ctx.async(2);
        this.connect(ctx.asyncAssertSuccess(conn -> {
            conn.query("SELECT id, message from immutable").execute(ctx.asyncAssertFailure(result -> {
                ctx.assertEquals((Object)2, (Object)async.count());
                async.countDown();
            }));
            conn.closeHandler(v -> {
                ctx.assertEquals((Object)1, (Object)async.count());
                async.countDown();
            });
            conn.close();
        }));
        async.await();
    }

    @Test
    public void testDatabaseMetaData(TestContext ctx) {
        this.connect(ctx.asyncAssertSuccess(conn -> {
            DatabaseMetadata md = conn.databaseMetadata();
            ctx.assertNotNull((Object)md, "DatabaseMetadata should not be null");
            ctx.assertNotNull((Object)md.productName(), "Database product name should not be null");
            ctx.assertNotNull((Object)md.fullVersion(), "Database full version string should not be null");
            ctx.assertTrue(md.majorVersion() >= 1, "Expected DB major version to be >= 1 but was " + md.majorVersion());
            ctx.assertTrue(md.minorVersion() >= 0, "Expected DB minor version to be >= 0 but was " + md.minorVersion());
            this.validateDatabaseMetaData(ctx, md);
        }));
    }

    protected void validateDatabaseMetaData(TestContext ctx, DatabaseMetadata md) {
        ctx.assertTrue(md.fullVersion().contains("Oracle"));
        ctx.assertTrue(md.productName().contains("Oracle"));
    }
}

