/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.oracleclient.test.tck.ClientConfig;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.tck.ConnectionAutoRetryTestBase;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class OracleConnectionAutoRetryTest
extends ConnectionAutoRetryTestBase {
    @ClassRule
    public static OracleRule rule = OracleRule.SHARED_INSTANCE;

    public void setUp() throws Exception {
        super.setUp();
        this.options = rule.options();
    }

    public void tearDown(TestContext ctx) {
        this.connectionConnector.close();
        this.poolConnector.close();
        super.tearDown(ctx);
    }

    protected void initialConnector(int proxyPort) {
        OracleConnectOptions proxyOptions = new OracleConnectOptions(this.options);
        proxyOptions.setPort(proxyPort);
        proxyOptions.setHost("localhost");
        this.connectionConnector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)proxyOptions);
        this.poolConnector = ClientConfig.POOLED.connect(this.vertx, (SqlConnectOptions)proxyOptions);
    }

    @Test
    @Ignore(value="Connection success, but any request get staled")
    public void testConnExceedingRetryLimit(TestContext ctx) {
        Async async = ctx.async();
        this.options.setReconnectAttempts(1);
        this.options.setReconnectInterval(1000L);
        ConnectionAutoRetryTestBase.UnstableProxyServer unstableProxyServer = new ConnectionAutoRetryTestBase.UnstableProxyServer((ConnectionAutoRetryTestBase)this, 2);
        unstableProxyServer.initialize(this.options, ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.connectionConnector.connect(s -> {
                ctx.assertFalse(s.succeeded());
                async.complete();
            });
        }));
    }

    @Test
    @Ignore(value="Connection success, but any request get staled")
    public void testPoolExceedingRetryLimit(TestContext ctx) {
        this.options.setReconnectAttempts(1);
        this.options.setReconnectInterval(1000L);
        ConnectionAutoRetryTestBase.UnstableProxyServer unstableProxyServer = new ConnectionAutoRetryTestBase.UnstableProxyServer((ConnectionAutoRetryTestBase)this, 2);
        unstableProxyServer.initialize(this.options, ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.poolConnector.connect(ctx.asyncAssertFailure(throwable -> {}));
        }));
    }
}

