/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.oracleclient.impl.OracleConnectionFactory;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;

public enum ClientConfig {
    CONNECT{

        Connector<SqlConnection> connect(final Vertx vertx, final SqlConnectOptions options) {
            return new Connector<SqlConnection>(){
                private OracleConnectionFactory factory;

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    this.factory = new OracleConnectionFactory((VertxInternal)vertx, new OracleConnectOptions(options.toJson()), new PoolOptions().setMaxSize(1), null, null);
                    Context context = vertx.getOrCreateContext();
                    this.factory.connect(context).onComplete(handler);
                }

                public void close() {
                    if (this.factory != null) {
                        this.factory.close(Promise.promise());
                    }
                }
            };
        }
    }
    ,
    POOLED{

        Connector<SqlConnection> connect(Vertx vertx, SqlConnectOptions options) {
            final OraclePool pool = OraclePool.pool((Vertx)vertx, (OracleConnectOptions)new OracleConnectOptions(options.toJson()), (PoolOptions)new PoolOptions().setMaxSize(5));
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    pool.getConnection(ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)((SqlConnection)ar.result())));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                    pool.close();
                }
            };
        }
    };


    abstract <C extends SqlClient> Connector<C> connect(Vertx var1, SqlConnectOptions var2);
}

