/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test.junit;

import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import java.time.Duration;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class OracleRule
extends ExternalResource {
    static final String IMAGE = "gvenzl/oracle-xe";
    static final String PASSWORD = "vertx";
    static final int PORT = 1521;
    static final GenericContainer<?> ORACLE_DB;
    private OracleConnectOptions options;
    public static final OracleRule SHARED_INSTANCE;

    public static String getPassword() {
        return PASSWORD;
    }

    public static String getUser() {
        return "sys as sysdba";
    }

    public static String getDatabaseHost() {
        return ORACLE_DB.getHost();
    }

    public static int getDatabasePort() {
        return ORACLE_DB.getMappedPort(1521);
    }

    public static String getDatabase() {
        return "xe";
    }

    public synchronized OracleConnectOptions getOptions() throws Exception {
        return new OracleConnectOptions().setPort(OracleRule.getDatabasePort()).setHost(OracleRule.getDatabaseHost()).setUser(OracleRule.getUser()).setPassword(OracleRule.getPassword()).setDatabase(OracleRule.getDatabase());
    }

    public OracleConnectOptions options() {
        return new OracleConnectOptions((SqlConnectOptions)this.options);
    }

    protected void before() throws Throwable {
        this.options = this.getOptions();
    }

    protected void after() {
    }

    static {
        String containerVersion = System.getProperty("oracle-container.version");
        if (containerVersion == null || containerVersion.isEmpty()) {
            containerVersion = "18-slim";
        }
        String image = "gvenzl/oracle-xe:" + containerVersion;
        ORACLE_DB = ((GenericContainer)new GenericContainer(image).withEnv("ORACLE_PASSWORD", PASSWORD).withExposedPorts(new Integer[]{1521}).withFileSystemBind("src/test/resources/tck", "/container-entrypoint-initdb.d")).withLogConsumer(of -> System.out.print("[ORACLE] " + of.getUtf8String())).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*DATABASE IS READY TO USE!.*\\n", (int)1)).withStartupTimeout(Duration.ofMinutes(15L));
        ORACLE_DB.start();
        SHARED_INSTANCE = new OracleRule();
    }
}

