/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.test;

import io.vertx.core.Vertx;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.oracleclient.test.OracleTestBase;
import io.vertx.oracleclient.test.junit.OracleRule;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;

public class OraclePoolTest
extends OracleTestBase {
    @Rule
    public OracleRule oracle;
    static final String DROP_TABLE = "DROP TABLE fruits";
    static final String CREATE_TABLE = "CREATE TABLE fruits (id integer PRIMARY KEY, name VARCHAR(100), quantity INTEGER)";
    static final String INSERT = "INSERT INTO fruits (id, name, quantity) VALUES (?, ?, ?)";

    @Test
    public void test() {
        OraclePool pool = OraclePool.pool((Vertx)vertx, (OracleConnectOptions)new OracleConnectOptions().setHost(OracleRule.getDatabaseHost()).setPort(OracleRule.getDatabasePort()).setUser(OracleRule.getUser()).setPassword(OracleRule.getPassword()).setDatabase(OracleRule.getDatabase()), (PoolOptions)new PoolOptions().setMaxSize(1));
        SqlConnection connection = (SqlConnection)OraclePoolTest.await(pool.getConnection());
        System.out.println(connection);
        System.out.println("metadata: " + connection.databaseMetadata().fullVersion() + " " + connection.databaseMetadata().productName());
        try {
            OraclePoolTest.await(connection.query(DROP_TABLE).execute());
        }
        catch (Exception exception) {
            // empty catch block
        }
        OraclePoolTest.await(connection.query(CREATE_TABLE).execute());
        OraclePoolTest.await(connection.prepare(INSERT).flatMap(ps -> ps.query().execute(Tuple.of((Object)1, (Object)"apple", (Object)10))));
        OraclePoolTest.await(connection.prepare(INSERT).flatMap(ps -> ps.query().execute(Tuple.of((Object)2, (Object)"pear", (Object)5))));
        OraclePoolTest.await(connection.prepare(INSERT).flatMap(ps -> ps.query().execute(Tuple.of((Object)3, (Object)"mango", (Object)3))));
        RowSet rows = (RowSet)OraclePoolTest.await(connection.query("SELECT * FROM fruits").execute());
        rows.forEach(row -> System.out.printf("[%d] %s : %d%n", row.get(Integer.class, 0), row.get(String.class, 1), row.get(Integer.class, 2)));
        RowSet res = (RowSet)OraclePoolTest.await(connection.query("SELECT * FROM fruits WHERE id = 1").execute());
        System.out.println("Select one : " + (String)((Row)res.iterator().next()).get(String.class, 1));
        System.out.println("Batch insert:");
        RowSet set = (RowSet)OraclePoolTest.await(connection.preparedQuery(INSERT).executeBatch(List.of(Tuple.of((Object)4, (Object)"pineapple", (Object)1), Tuple.of((Object)5, (Object)"kiwi", (Object)2), Tuple.of((Object)6, (Object)"orange", (Object)3), Tuple.of((Object)7, (Object)"strawberry", (Object)20))));
        System.out.println(set.size());
        rows = (RowSet)OraclePoolTest.await(connection.query("SELECT * FROM fruits").execute());
        rows.forEach(row -> System.out.printf("[%d] %s : %d%n", row.get(Integer.class, 0), row.get(String.class, 1), row.get(Integer.class, 2)));
        System.out.println("Transaction:");
        OraclePoolTest.await(connection.begin().flatMap(tx -> connection.prepare(INSERT).flatMap(ps -> ps.query().execute(Tuple.of((Object)20, (Object)"olive", (Object)200))).flatMap(x -> tx.commit()).eventually(x -> tx.rollback())));
        OraclePoolTest.await(connection.begin().flatMap(tx -> connection.prepare(INSERT).flatMap(ps -> ps.query().execute(Tuple.of((Object)23, (Object)"nope", (Object)-2))).flatMap(x -> tx.rollback()).eventually(x -> tx.rollback())));
        rows = (RowSet)OraclePoolTest.await(connection.query("SELECT * FROM fruits").execute());
        rows.forEach(row -> System.out.printf("[%d] %s : %d%n", row.get(Integer.class, 0), row.get(String.class, 1), row.get(Integer.class, 2)));
        OraclePoolTest.await(connection.close());
    }
}

