package io.vertx.oracleclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.PrepareOptions;

@DataObject(generateConverter = true, inheritConverter = true)
public class OraclePrepareOptions extends PrepareOptions {

  public static final boolean DEFAULT_AUTO_GENERATED_KEY = true;

  private boolean autoGeneratedKeys = DEFAULT_AUTO_GENERATED_KEY;
  private JsonArray autoGeneratedKeysIndexes;

  public OraclePrepareOptions() {
  }

  public OraclePrepareOptions(OraclePrepareOptions options) {
    this.autoGeneratedKeys = options.autoGeneratedKeys;
    this.autoGeneratedKeysIndexes = options.autoGeneratedKeysIndexes != null ? options.autoGeneratedKeysIndexes.copy() : null;
  }

  public OraclePrepareOptions(JsonObject json) {
    OraclePrepareOptionsConverter.fromJson(json, this);
  }

  public boolean isAutoGeneratedKeys() {
    return autoGeneratedKeys;
  }

  public OraclePrepareOptions setAutoGeneratedKeys(boolean autoGeneratedKeys) {
    this.autoGeneratedKeys = autoGeneratedKeys;
    return this;
  }

  public JsonArray getAutoGeneratedKeysIndexes() {
    return autoGeneratedKeysIndexes;
  }

  public OraclePrepareOptions setAutoGeneratedKeysIndexes(JsonArray autoGeneratedKeysIndexes) {
    this.autoGeneratedKeysIndexes = autoGeneratedKeysIndexes;
    return this;
  }
}
