/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.mssqlclient.MSSQLInfoConverter;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class MSSQLInfo {
    private int number;
    private byte state;
    private byte severity;
    private String message;
    private String serverName;
    private String procedureName;
    private int lineNumber;

    public MSSQLInfo() {
    }

    public MSSQLInfo(MSSQLInfo other) {
        this.number = other.number;
        this.state = other.state;
        this.severity = other.severity;
        this.message = other.message;
        this.serverName = other.serverName;
        this.procedureName = other.procedureName;
        this.lineNumber = other.lineNumber;
    }

    public MSSQLInfo(JsonObject json) {
        MSSQLInfoConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        MSSQLInfoConverter.toJson(this, json);
        return json;
    }

    public int getNumber() {
        return this.number;
    }

    public MSSQLInfo setNumber(int number) {
        this.number = number;
        return this;
    }

    public byte getState() {
        return this.state;
    }

    public MSSQLInfo setState(byte state) {
        this.state = state;
        return this;
    }

    public byte getSeverity() {
        return this.severity;
    }

    public MSSQLInfo setSeverity(byte severity) {
        this.severity = severity;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public MSSQLInfo setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public MSSQLInfo setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public MSSQLInfo setProcedureName(String procedureName) {
        this.procedureName = procedureName;
        return this;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public MSSQLInfo setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MSSQL Info {").append("number=").append(this.number).append(", state=").append(this.state).append(", severity=").append(this.severity);
        if (this.message != null && !this.message.isEmpty()) {
            sb.append(", message='").append(this.message).append('\'');
        }
        if (this.serverName != null && !this.serverName.isEmpty()) {
            sb.append(", serverName='").append(this.serverName).append('\'');
        }
        if (this.procedureName != null && !this.procedureName.isEmpty()) {
            sb.append(", procedureName='").append(this.procedureName).append('\'');
        }
        sb.append(", lineNumber=").append(this.lineNumber);
        return sb.append('}').toString();
    }
}

