/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.tck;

import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.mssqlclient.MSSQLException;
import io.vertx.tests.mssqlclient.junit.MSSQLRule;
import io.vertx.tests.sqlclient.tck.PreparedQueryTestBase;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public abstract class MSSQLPreparedQueryTestBase
extends PreparedQueryTestBase {
    @ClassRule
    public static MSSQLRule rule = MSSQLRule.SHARED_INSTANCE;

    protected boolean cursorRequiresTx() {
        return false;
    }

    protected void cleanTestTable(TestContext ctx) {
        this.connect(ctx.asyncAssertSuccess(conn -> conn.query("TRUNCATE TABLE mutable;").execute().onComplete(ctx.asyncAssertSuccess(result -> conn.close()))));
    }

    protected String statement(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append("@p").append(i);
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    @Test
    public void testPrepareError(TestContext ctx) {
        this.connect(ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT whatever FROM DOES_NOT_EXIST").onComplete(ctx.asyncAssertSuccess(ps -> ps.query().execute().onComplete(ctx.asyncAssertFailure(error -> {
            ctx.assertTrue(error instanceof MSSQLException);
            MSSQLException e = (MSSQLException)error;
            ctx.assertEquals((Object)"Invalid object name 'DOES_NOT_EXIST'.", (Object)e.errorMessage());
        }))))));
    }

    @Test
    @Ignore
    public void testPreparedQueryParamCoercionQuantityError(TestContext ctx) {
        super.testPreparedQueryParamCoercionQuantityError(ctx);
    }

    @Test
    @Ignore
    public void testPreparedQueryParamCoercionTypeError(TestContext ctx) {
        super.testPreparedQueryParamCoercionTypeError(ctx);
    }

    @Test
    public void failureWhenPreparingCursor(TestContext ctx) {
        Async async = ctx.async();
        this.connect(ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT invalid_function()").onComplete(ctx.asyncAssertSuccess(ps -> ps.createStream(50).exceptionHandler(error -> {
            ctx.assertTrue(error instanceof MSSQLException);
            MSSQLException e = (MSSQLException)error;
            ctx.assertEquals((Object)"'invalid_function' is not a recognized built-in function name.", (Object)e.errorMessage());
            async.complete();
        }).handler(row -> ctx.fail())))));
    }
}

