/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.mssqlclient.junit;

import io.vertx.mssqlclient.MSSQLConnectOptions;
import java.io.IOException;
import java.util.Objects;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.InternetProtocol;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MSSQLRule
extends ExternalResource {
    public static final MSSQLRule SHARED_INSTANCE = new MSSQLRule(Config.STANDARD);
    private static final String USER = "SA";
    private static final String PASSWORD = "A_Str0ng_Required_Password";
    private static final String INIT_SQL = "/opt/data/init.sql";
    private final Config config;
    private ServerContainer<?> server;
    private MSSQLConnectOptions options;

    public MSSQLRule(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    protected void before() throws IOException {
        String connectionUri = System.getProperty(this.config.connectionUriSystemProperty);
        if (!this.isNullOrEmpty(connectionUri)) {
            this.options = MSSQLConnectOptions.fromUri((String)connectionUri);
        } else if (this.server == null) {
            this.options = this.startMSSQL();
        }
    }

    private boolean isNullOrEmpty(String connectionUri) {
        return connectionUri == null || connectionUri.isEmpty();
    }

    protected void after() {
        if (this.isNullOrEmpty(System.getProperty(this.config.connectionUriSystemProperty)) && this != SHARED_INSTANCE) {
            this.stopMSSQL();
        }
    }

    private MSSQLConnectOptions startMSSQL() throws IOException {
        String containerVersion = System.getProperty("mssql-container.version");
        if (this.isNullOrEmpty(containerVersion)) {
            containerVersion = "2019-latest";
        }
        this.server = (ServerContainer)((ServerContainer)((ServerContainer)((ServerContainer)((ServerContainer)new ServerContainer("mcr.microsoft.com/mssql/server:" + containerVersion).withEnv("ACCEPT_EULA", "Y")).withEnv("TZ", "UTC")).withEnv("SA_PASSWORD", PASSWORD)).withClasspathResourceMapping("init.sql", INIT_SQL, BindMode.READ_ONLY)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*The tempdb database has \\d+ data file\\(s\\).*\\n", (int)2));
        if (System.getProperties().containsKey("containerFixedPort")) {
            this.server.withFixedExposedPort(1433, 1433);
        } else {
            this.server.withExposedPorts(new Integer[]{1433});
        }
        if (!this.isNullOrEmpty(this.config.mssqlConf)) {
            ((ServerContainer)((ServerContainer)this.server.withClasspathResourceMapping(this.config.mssqlConf, "/var/opt/mssql/mssql.conf", BindMode.READ_ONLY)).withClasspathResourceMapping("mssql.key", "/etc/ssl/certs/mssql.key", BindMode.READ_ONLY)).withClasspathResourceMapping("mssql.pem", "/etc/ssl/certs/mssql.pem", BindMode.READ_ONLY);
        }
        this.server.start();
        this.initDb();
        return new MSSQLConnectOptions().setHost(this.server.getHost()).setPort(this.server.getMappedPort(1433).intValue()).setUser(USER).setPassword(PASSWORD);
    }

    private void initDb() throws IOException {
        try {
            Container.ExecResult execResult = this.server.execInContainer(new String[]{"/opt/mssql-tools18/bin/sqlcmd", "-S", "localhost", "-U", USER, "-P", PASSWORD, "-i", INIT_SQL, "-C", "-No"});
            if (execResult.getExitCode() != 0) {
                throw new RuntimeException(String.format("Failure while initializing database%nstdout:%s%nstderr:%s%n", execResult.getStdout(), execResult.getStderr()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void stopMSSQL() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
    }

    public MSSQLConnectOptions options() {
        return new MSSQLConnectOptions(this.options);
    }

    private static class ServerContainer<SELF extends ServerContainer<SELF>>
    extends GenericContainer<SELF> {
        public ServerContainer(String dockerImageName) {
            super(dockerImageName);
        }

        public SELF withFixedExposedPort(int hostPort, int containerPort) {
            super.addFixedExposedPort(hostPort, containerPort, InternetProtocol.TCP);
            return (SELF)((Object)((ServerContainer)this.self()));
        }
    }

    public static enum Config {
        STANDARD("connection.uri", null),
        TLS("tls.connection.uri", "mssql-tls.conf"),
        FORCE_ENCRYPTION("force.encryption.connection.uri", "mssql-force-encryption.conf");

        private final String connectionUriSystemProperty;
        private final String mssqlConf;

        private Config(String connectionUriSystemProperty, String mssqlConf) {
            this.connectionUriSystemProperty = connectionUriSystemProperty;
            this.mssqlConf = mssqlConf;
        }
    }
}

